% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipois.R
\name{zipois}
\alias{zipois}
\alias{dzipois}
\alias{pzipois}
\alias{rzipois}
\title{Zero-inflated Poisson distribution}
\usage{
dzipois(x, lambda, zeroprob = 0, log = FALSE)

pzipois(q, lambda, zeroprob = 0, lower.tail = TRUE, log.p = FALSE)

rzipois(n, lambda, zeroprob = 0)
}
\arguments{
\item{x, q}{integer vector of counts}

\item{lambda}{vector of (non-negative) means}

\item{zeroprob}{zero-inflation probability between 0 and 1}

\item{log, log.p}{logical; return log-density if TRUE}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{n}{number of random values to return.}
}
\value{
\code{dzipois} gives the probability mass function, \code{pzipois} gives the distribution function, and \code{rzipois} generates random deviates.
}
\description{
Probability mass function, distribution function, and random generation for
the zero-inflated Poisson distribution.
}
\details{
This implementation allows for automatic differentiation with \code{RTMB}.
}
\examples{
set.seed(123)
x <- rzipois(1, 0.5, 1)
d <- dzipois(x, 0.5, 1)
p <- pzipois(x, 0.5, 1)
}
