% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrpcauchy.R
\name{wrpcauchy}
\alias{wrpcauchy}
\alias{dwrpcauchy}
\alias{rwrpcauchy}
\title{wrapped Cauchy distribution}
\usage{
dwrpcauchy(x, mu = 0, rho, log = FALSE)

rwrpcauchy(n, mu = 0, rho, wrap = TRUE)
}
\arguments{
\item{x}{vector of angles measured in radians at which to evaluate the density function.}

\item{mu}{mean direction of the distribution measured in radians.}

\item{rho}{concentration parameter of the distribution, must be in the interval from 0 to 1.}

\item{log}{logical; if \code{TRUE}, densities are returned on the log scale.}

\item{n}{number of random values to return.}

\item{wrap}{logical; if \code{TRUE}, generated angles are wrapped to the interval from -pi to pi.}
}
\value{
\code{dwrpcauchy} gives the density and \code{rwrpcauchy} generates random deviates.
}
\description{
Density and random generation for the wrapped Cauchy distribution.
}
\details{
This implementation of \code{dwrpcauchy} allows for automatic differentiation with \code{RTMB}.
\code{rwrpcauchy} is simply a wrapper for \code{rwrappedcauchy}imported from \code{circular}.
}
\examples{
set.seed(1)
x <- rwrpcauchy(10, 0, 0.5)
d <- dwrpcauchy(x, 0, 0.5)
}
