% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_rb2stage.R
\name{n.rb.2stage.2}
\alias{n.rb.2stage.2}
\title{Sample size for 2-stage risk-based surveillance, allowing for risk factors at either or both cluster and unit level}
\usage{
n.rb.2stage.2(rr.c, ppr.c, spr.c, pstar.c, rr.u = 1, ppr.u = 1,
  spr.u = 1, pstar.u, se = 1, sep.c = 0.95, sep.sys = 0.95)
}
\arguments{
\item{rr.c}{relative risk values at the cluster level (vector of values, corresponding 
to the number of risk strata)}

\item{ppr.c}{population proportions at the cluster level, corresponding to 
rr.c values (vector of equal length to rr.c)}

\item{spr.c}{planned surveillance proportions at the cluster level, corresponding to 
rr.c values - the proportions of the total sample to be collected 
from each risk stratum (vector of equal length to rr.c).}

\item{pstar.c}{cluster (herd) level design prevalence, scalar,
either proportion or integer}

\item{rr.u}{relative risk values at the unit level (vector of values, corresponding 
to the number of risk strata)}

\item{ppr.u}{population proportions at the unit level, corresponding to 
rr.u values (vector of equal length to rr.u)}

\item{spr.u}{planned surveillance proportions at the unit level, corresponding to 
rr.u values - the proportions of the total sample to be collected 
from each risk stratum (vector of equal length to rr.u).}

\item{pstar.u}{unit (animal) level design prevalence, scalar,
either proportion or integer}

\item{se}{unit sensitivity of test (proportion), scalar, default = 1}

\item{sep.c}{desired cluster-level sensitivity (proportion), scalar, default = 0.95}

\item{sep.sys}{desired population-level sensitivity (proportion), scalar, default = 0.95}
}
\value{
A list of cluster and unit level results number of clusters/units to 
sample per risk stratum, the total number of clusters or units per cluster to be sampled and
vectors of EPI and adjusted risk values for each risk stratum.
}
\description{
Calculates sample size required (clusters and units)
for a 2-stage risk-based survey with risk factors at either 
cluster level or unit level, or both.
}
\examples{
rr.c<- c(5,3,1)
ppr.c<- c(0.1, 0.2, 0.7)
spr.c<- c(0.4, 0.4, 0.2)
rr.u<- c(4,1)
ppr.u<- c(0.1, 0.9)
spr.u<- c(1, 0)
n.rb.2stage.2(rr.c, ppr.c, spr.c, pstar.c=0.02, rr.u, ppr.u, 
  spr.u, 0.1, se=0.9, sep.c=0.5, sep.sys=0.95) 
n.rb.2stage.2(c(3,1), c(0.2,0.8), c(0.7,0.3), pstar.c=0.05, 
  pstar.u=0.1, se=0.9, sep.c=0.95, sep.sys=0.99)
}
\keyword{methods}
