% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freedom_functions_1.R
\name{n.pfree}
\alias{n.pfree}
\title{Sample size to achieve desired (posterior) probability of freedom}
\usage{
n.pfree(pfree, prior, p.intro, pstar, se, N = NA)
}
\arguments{
\item{pfree}{desired probability of freedom (scalar or vector)}

\item{prior}{prior probability of freedom before surveillance (scalar
or vector of same length as pfree)}

\item{p.intro}{probability of introduction for time period (scalar
or vector of same length as pfree)}

\item{pstar}{design prevalence (scalar
or vector of same length as pfree)}

\item{se}{unit sensitivity (scalar
or vector of same length as pfree)}

\item{N}{population size (scalar
or vector of same length as pfree)}
}
\value{
a list of 3 elements, the first a vector of sample sizes
and the second a corresponding vector of population sensitivity values
and the third a vector of adjusted priors
}
\description{
Calculates the sample size required to achieve a
  given value for probability of disease freedom
}
\examples{
# examples for n.pfree
n.pfree(0.95, 0.5, 0.01, 0.05, 0.9)
n.pfree(0.95, 0.5, 0.01, 0.05, 0.9, N=300)
n.pfree(pfree = c(0.9, 0.95, 0.98, 0.99), prior = 0.7, 0.01, 0.01, 0.8, 1000)
n.pfree(0.95, 0.7, 0.01, 0.1, 0.96)
}
\keyword{methods}
