% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freedom_functions_2.R
\name{n.c.hp}
\alias{n.c.hp}
\title{Hypergeometric (HerdPlus) optimum sample size and cut-point number 
of positives}
\usage{
n.c.hp(N, sep = 0.95, c = 1, se, sp = 1, pstar, minSpH = 0.95)
}
\arguments{
\item{N}{population size}

\item{sep}{target population sensitivity}

\item{c}{The maximum allowed cut-point number of positives to classify a cluster
as positive, default=1, if positives < c result is negative, >= c is positive}

\item{se}{test unit sensitivity}

\item{sp}{test unit specificity, default=1}

\item{pstar}{design prevalence as a proportion or integer (number of infected units)}

\item{minSpH}{minimium desired population specificity}
}
\value{
a list of 3 elements, a dataframe with 1 row and six columns for
  the recommended sample size and corresponding values for population sensitivity (SeP),
  population specificity (SpP), N, c and pstar, a vector of SeP values
  and a vector of SpP values, for n = 1:N
}
\description{
Calculates optimum sample size and cut-point positives 
  to achieve specified population sensitivity, for 
  given population size and other parameters, all paramaters must be scalars
}
\examples{
# examples for n.c.hp
n.c.hp(65,0.95,c=5,se=0.95,sp=0.99,pstar=0.05, minSpH=0.9)[[1]]
tmp<- n.c.hp(120,0.95,c=5,se=0.9,sp=0.99,pstar=0.1, minSpH=0.9)
}
\keyword{methods}
