% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empiricalsmalltelescopes.R
\name{EstimatePower}
\alias{EstimatePower}
\title{Estimate Power}
\usage{
EstimatePower(data, n.original, B.power, analysis, n.rows, alpha)
}
\arguments{
\item{data}{Dataset (matrix).}

\item{n.original}{The sample size of the original analysis (scalar).}

\item{B.power}{The number of samples to be simulated (scalar).}

\item{analysis}{Function to produce a p value and an effect size estimate.}

\item{n.rows}{The number of rows per subject in the dataset (scalar)}

\item{alpha}{Set alpha level for analysis (scalar)}
}
\value{
Power estimate generated through simulation (scalar).
}
\description{
Estimate statistical power of an effect size parameter by simulation using
original sample size.
}
\examples{
# create or import dataset
 example.data <- matrix(rnorm(50), 25, 2)  

# estimate statistical power
 EstimatePower(
   data = example.data, 
   n.original = 10, 
   analysis = function(data) {
     corr <- cor.test(data[,1], data[,2])
     return(list(effect.size = corr$estimate, p.value = corr$p.value))
   }, 
   B.power = 100,
   n.rows = 1, 
   alpha = 0.05)
}
