% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_car.R
\name{car}
\alias{car}
\alias{rcar}
\alias{mcar}
\alias{mstcar}
\title{Create CAR model}
\usage{
car(
  name,
  data,
  adjacency,
  dir = tempdir(),
  seed = NULL,
  perc_ci = 0.95,
  iterations = 6000,
  show_plots = TRUE,
  verbose = TRUE,
  ignore_checks = FALSE,
  method = c("binomial", "poisson"),
  impute_bounds = NULL,
  inits = NULL,
  priors = NULL
)

rcar(
  name,
  data,
  adjacency,
  dir = tempdir(),
  seed = NULL,
  perc_ci = 0.95,
  A = NULL,
  m0 = NULL,
  iterations = 6000,
  show_plots = TRUE,
  verbose = TRUE,
  ignore_checks = FALSE,
  method = c("binomial", "poisson"),
  impute_bounds = NULL,
  inits = NULL,
  priors = NULL
)

mcar(
  name,
  data,
  adjacency,
  dir = tempdir(),
  seed = NULL,
  perc_ci = 0.95,
  iterations = 6000,
  show_plots = TRUE,
  verbose = TRUE,
  ignore_checks = FALSE,
  method = c("binomial", "poisson"),
  impute_bounds = NULL,
  inits = NULL,
  priors = NULL
)

mstcar(
  name,
  data,
  adjacency,
  dir = tempdir(),
  seed = NULL,
  perc_ci = 0.95,
  iterations = 6000,
  show_plots = TRUE,
  verbose = TRUE,
  ignore_checks = FALSE,
  method = c("binomial", "poisson"),
  impute_bounds = NULL,
  inits = NULL,
  priors = NULL,
  update_rho = FALSE
)
}
\arguments{
\item{name}{Name of model and corresponding folder.}

\item{data}{Dataset including mortality (Y) and population (n) information.}

\item{adjacency}{Dataset including adjacency information.}

\item{dir}{Directory where model will live.}

\item{seed}{Set of random seeds to use for data replication.}

\item{perc_ci}{The percentage of the desired estimate credible interval. Defaults to 95 percent (0.95).}

\item{iterations}{The number of iterations to run the model for.}

\item{show_plots}{If set to \code{FALSE}, suppresses traceplots.}

\item{verbose}{If set to \code{FALSE}, suppresses model progress messages.}

\item{ignore_checks}{If set to \code{TRUE}, skips model validation.}

\item{method}{Run model with either Binomial data or Poisson data.}

\item{impute_bounds}{If counts are suppressed for privacy reasons, \code{impute_bounds} is the lower/upper bound of suppression, typically 0 or 1 and 10, respectively.}

\item{inits}{Optional list of initial conditions for each parameter.}

\item{priors}{Optional list of priors for updates.}

\item{A}{For RCAR models, describes maximum intensity of smoothing between regions.}

\item{m0}{For RCAR models, baseline neighbor count by region.}

\item{update_rho}{For MSTCAR models, controls whether rho update is performed.}
}
\value{
An \code{RSTr} model object.
}
\description{
\code{*car()} generates an \code{RSTr} model object, samples, and estimates for either an MSTCAR, MCAR, RCAR, or CAR model.
}
\examples{
data_min <- lapply(miheart, \(x) x[1:2, 1:3, 1:3])
adj_min <- list(2, 1)
# MSTCAR model
on.exit(unlink(file.path(tempdir(), "test"), recursive = TRUE), add = TRUE)
mod_mst <- mstcar(
  name = "test",
  data = data_min,
  adjacency = adj_min,
  dir = tempdir(),
  show_plots = FALSE,
  verbose = FALSE
)
}
