% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_age_standardize.R
\name{age_standardize}
\alias{age_standardize}
\title{Age-standardize model objects}
\usage{
age_standardize(RSTr_obj, std_pop, new_name, groups = NULL)
}
\arguments{
\item{RSTr_obj}{An \code{RSTr} model object.}

\item{std_pop}{A vector of standard populations.}

\item{new_name}{The name to assign to the age-standardized group.}

\item{groups}{A vector of either indices for each group or a vector of strings for each group name. If set to \code{NULL}, will use all groups in the dataset.}
}
\value{
An \code{RSTr} object with age-standardized estimates.
}
\description{
Age-standardizes samples using a standard population for an \code{RSTr} model object.
}
\examples{
std_pop <- c(113154, 100640, 95799)
data_min <- lapply(miheart, \(x) x[1:2, 1:3, 1:3])
adj_min <- list(2, 1)
mod_mst <- mstcar("test", data_min, adj_min, tempdir(), show_plots = FALSE, verbose = FALSE)
# age-standardize by all age groups
mod_mst <- age_standardize(mod_mst, std_pop, "35-64")
# Add onto age-standardized estimates. Age-standardize only by the first two age groups
mod_mst <- age_standardize(mod_mst, std_pop[1:2], "35-54", groups = 1:2)
\dontshow{
unlink(paste0(tempdir(), "\\\\test"), recursive = TRUE)
}
}
