% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_corr.R
\name{rsdc_forecast}
\alias{rsdc_forecast}
\title{Forecast Covariance/Correlation Paths from an RSDC Model}
\usage{
rsdc_forecast(
  method = c("tvtp", "noX", "const"),
  N,
  residuals,
  X = NULL,
  final_params,
  sigma_matrix,
  value_cols,
  out_of_sample = FALSE,
  control = list()
)
}
\arguments{
\item{method}{Character. One of \code{"tvtp"}, \code{"noX"}, \code{"const"}.}

\item{N}{Integer. Number of regimes (ignored for \code{"const"}).}

\item{residuals}{Numeric matrix \eqn{T \times K} used to compute correlations or run the filter.}

\item{X}{Optional numeric matrix \eqn{T \times p} (required for \code{"tvtp"}).}

\item{final_params}{List with fitted parameters (e.g., from \code{\link{rsdc_estimate}}):
must include \code{correlations}, and either \code{transition_matrix} (\code{"noX"})
or \code{beta} (\code{"tvtp"}); include \code{log_likelihood} for BIC computation.}

\item{sigma_matrix}{Numeric matrix \eqn{T \times K} of forecasted standard deviations.}

\item{value_cols}{Character/integer vector of columns in \code{sigma_matrix} that define asset order.}

\item{out_of_sample}{Logical. If \code{TRUE}, use a fixed 70/30 split; otherwise use the whole sample.}

\item{control}{Optional list; supports \code{threshold} (in (0,1), default \code{0.7}).}
}
\value{
\describe{
\item{\code{smoothed_probs}}{\eqn{N \times T^\ast} smoothed probabilities (\code{"noX"}/\code{"tvtp"} only).}
\item{\code{sigma_matrix}}{\eqn{T^\ast \times K} slice aligned to the forecast horizon.}
\item{\code{cov_matrices}}{List of \eqn{K \times K} covariance matrices \eqn{\Sigma_t = D_t R_t D_t}.}
\item{\code{predicted_correlations}}{\eqn{T^\ast \times \binom{K}{2}} pairwise correlations in \code{combn(K, 2)} order.}
\item{\code{BIC}}{Bayesian Information Criterion \eqn{\mathrm{BIC} = \log(n)\,k - 2\,\ell}.}
\item{\code{y}}{\eqn{T^\ast \times K} residual matrix aligned to the forecast horizon.}
}
}
\description{
Generates per-period correlation and covariance matrices from a fitted model:
\code{"const"} (constant correlation), \code{"noX"} (fixed transition matrix), or
\code{"tvtp"} (time-varying transition probabilities).
}
\details{
\itemize{
\item \strong{Forecast horizon:} If \code{out_of_sample = TRUE}, filter on the first \code{threshold}
fraction and forecast on the remainder.
\item \strong{Correlation paths:}
\itemize{
\item \code{"const"} — empirical correlation of \code{residuals}, repeated across time.
\item \code{"noX"}/\code{"tvtp"} — smoothed-probability weighted average of regime correlations.
}
\item \strong{Covariance build:} Reconstruct \eqn{R_t} from the pairwise vector (columns ordered by
\code{combn(K, 2)}), set \eqn{D_t = \mathrm{diag}(\sigma_{t,1},\dots,\sigma_{t,K})}, and
\eqn{\Sigma_t = D_t R_t D_t}.
\item \strong{BIC:} Parameter count \eqn{k} is
\code{N * ncol(X) + N * K * (K - 1) / 2} for \code{"tvtp"},
\code{N * (N - 1) + N * K * (K - 1) / 2} for \code{"noX"},
and \code{K * (K - 1) / 2} for \code{"const"}.
}
}
\examples{
set.seed(123)
T <- 60; K <- 3; N <- 2
y <- scale(matrix(rnorm(T*K), T, K))
vols <- matrix(0.2 + 0.05*abs(sin(seq_len(T)/7)), T, K)
rho <- rbind(c(0.10, 0.05, 0.00), c(0.60, 0.40, 0.30))
Pfix <- matrix(c(0.9, 0.1, 0.2, 0.8), 2, 2, byrow = TRUE)
rsdc_forecast("noX", N, y, NULL,
              list(correlations = rho, transition_matrix = Pfix, log_likelihood = -200),
              vols, 1:K)
}
\seealso{
\code{\link{rsdc_hamilton}}, \code{\link{rsdc_estimate}},
\code{\link{rsdc_minvar}}, \code{\link{rsdc_maxdiv}}
}
