% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loopcuts_umbrella.R
\name{loopcuts_umbrella}
\alias{loopcuts_umbrella}
\title{Change-point p-values with backward elimination under umbrella alternative order restriction}
\usage{
loopcuts_umbrella(time,censor,cuttimes,mono)
}
\arguments{
\item{time}{a sequence of time}

\item{censor}{a vector indicating censored or not at the given times, 0 = censored; 1 = uncensored}

\item{cuttimes}{unique, sorted, possible times to make the cuts, including 0 and the ending time}

\item{mono}{0: 2-sided hypothesis: H0: lam1 is equal to lam2; H1: lam1 is not equal to lam2
1: 1-sided hypothesis: H0: lam1 is greater than or equal to lam2; H1: lam1 is less than lam2
2: 1-sided hypothesis: H0: lam1 is less than or equal to lam2; H1: lam1 is greater than lam2}
}
\value{
the times in the backward elimination procedure and the corresponding p-values for each change-point in the iteration
}
\description{
A function that iterates to compute the p-values from the backward elimination procedure (Han et al. 2014) with umbrella alternative order restriction.
}
\examples{
data(loopcuts_t_c)
data(loopcuts_umbrella_cuttimes_mono)
time = loopcuts_t_c[,1]
censor = loopcuts_t_c[,2]
cuttimes = loopcuts_umbrella_cuttimes_mono[,1]
mono = loopcuts_umbrella_cuttimes_mono[,2]
loopcuts_umbrella(time, censor, cuttimes, mono)
}
