% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REGIME.R
\name{apply.REGIME}
\alias{apply.REGIME}
\title{Apply REGIME method (using a beneficial.vector)}
\usage{
apply.REGIME(mat, beneficial.vector, weights, doPreOrder = FALSE)
}
\arguments{
\item{mat}{A numeric matrix of size n x m (n alternatives, m criteria).}

\item{beneficial.vector}{An integer vector of columns that are beneficial ("max").
All other columns are assumed to be "min".}

\item{weights}{A numeric vector of length m, containing weights for each criterion.}

\item{doPreOrder}{A logical. If TRUE, the function also calls apply.po.ranking
on the resulting cp.matrix and returns both the matrix and the partial-order
results in a list.}
}
\value{
\itemize{
\item If doPreOrder = FALSE, returns an n x n character matrix cp.matrix.
\item If doPreOrder = TRUE, returns a list with two elements:
\itemize{
\item cp.matrix: the character matrix
\item po.result: the output from apply.po.ranking
}
}
}
\description{
This function implements the REGIME method of pairwise comparisons to produce a
character matrix (cp.matrix) that marks each pair of alternatives as either
"P+" (row dominates column), "I" (indifferent), or "-" (for diagonals).
}
\details{
It uses a beneficial.vector of column indices for "max" criteria. Columns not in
beneficial.vector are treated as "min". The function can optionally run
apply.po.ranking on the resulting matrix for partial-order analysis.
\enumerate{
\item Weights Normalization: We first normalize the weights so their sum equals 1.
\item Pairwise Comparison Matrix (g_ind):
\itemize{
\item For each pair of alternatives and each criterion:
\itemize{
\item If the criterion is beneficial (maximization) and the value for one alternative
is greater than or equal to the value for another alternative, the weight for that
criterion is added to the pair's comparison score (g_ind).
Otherwise, the weight is subtracted from the score.
\item If the criterion is non-beneficial (minimization) and the value for one alternative
is less than the value for another alternative, the weight is added to the score.
Otherwise, the weight is subtracted.
}
}
\item cp.matrix:
\itemize{
\item "P+" indicates that one alternative dominates another if the comparison score (g_ind) is greater than 0.
\item "I" indicates that the alternatives are indifferent if the comparison score is 0
or if the scores for both directions are equal.
\item "-" is assigned to diagonal entries, where the alternatives are compared with themselves.
}
\item If doPreOrder = TRUE, the function calls apply.po.ranking on cp.matrix to merge indifferent alternatives ("I")
and construct a partial order.
}
}
\examples{
# Example data: 3 alternatives x 2 criteria
mat <- matrix(c(10, 5,
                12, 4,
                11, 6), nrow = 3, byrow = TRUE)

# Suppose first column is beneficial, second is non-beneficial
benef.vec <- c(1)  # means col1 is "max", col2 is "min"
wts <- c(0.6, 0.4)

# Call apply.REGIME without partial-order
regime.out <- apply.REGIME(mat, benef.vec, wts, doPreOrder = FALSE)


# Or with partial-order
regime.out2 <- apply.REGIME(mat, benef.vec, wts, doPreOrder = TRUE)

}
