% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComprehensiveTemperatureGenerator.R
\name{ComprehensiveTemperatureGenerator}
\alias{ComprehensiveTemperatureGenerator}
\title{The Comprehensive Temperature Generator}
\usage{
ComprehensiveTemperatureGenerator(
  station = c("T0001", "T0010", "T0099"),
  Tx_all,
  Tn_all,
  mean_climate_Tn = NULL,
  mean_climate_Tx = NULL,
  Tx_spline = NULL,
  Tn_spline = NULL,
  year_max = 1990,
  year_min = 1961,
  leap = TRUE,
  nmonth = 12,
  verbose = TRUE,
  p = 1,
  type = "none",
  lag.max = NULL,
  ic = "AIC",
  activateVARselect = FALSE,
  year_max_sim = year_max,
  year_min_sim = year_min,
  mean_climate_Tn_sim = NULL,
  mean_climate_Tx_sim = NULL,
  Tn_spline_sim = NULL,
  Tx_spline_sim = NULL,
  onlygeneration = FALSE,
  varmodel = NULL,
  normalize = TRUE,
  type_quantile = 3,
  sample = NULL,
  extremes = TRUE,
  option = 2,
  yearly = FALSE,
  yearly_sim = yearly,
  n_GPCA_iteration = 0,
  n_GPCA_iteration_residuals = n_GPCA_iteration,
  exogen = NULL,
  exogen_sim = exogen,
  is_exogen_gaussian = FALSE,
  exogen_all = NULL,
  exogen_all_col = station,
  nscenario = 1,
  seed = NULL,
  noise = NULL,
  nearPD = FALSE
)
}
\arguments{
\item{station}{see respective input parameter on \code{\link{setComprehensiveTemperatureGeneratorParameters}}}

\item{Tx_all, Tn_all, mean_climate_Tn, mean_climate_Tx, Tx_spline, Tn_spline}{see respective input parameter on \code{\link{setComprehensiveTemperatureGeneratorParameters}}}

\item{year_max, year_min, leap, nmonth, verbose}{see respective input parameter on \code{\link{setComprehensiveTemperatureGeneratorParameters}}}

\item{p, type, lag.max, ic, activateVARselect}{see respective input parameter on \code{\link{getVARmodel}}}

\item{year_max_sim}{last year of the simulation period. Default is equal to \code{year_max}}

\item{year_min_sim}{first year of the simulation period. Default is equal to \code{year_min}}

\item{mean_climate_Tn_sim}{monthly averaged daily minimum temperatures for the simulated scenario and used by the random generator .  Default is \code{mean_climate_Tn}}

\item{mean_climate_Tx_sim}{monthly averaged daily maximum temperatures for the simulated scenario and used by the random generator .  Default is \code{mean_climate_Tx}}

\item{Tn_spline_sim}{daily timeseries (from the first day of \code{year_min_sim} to the last day of \code{year_max_sim}) of averaged minimum temperature which can be obtained by a spline interpolation of monthly mean values (for the generation period). Default is \code{Tn_spline}. See for spline interpolation utilized \code{\link{splineInterpolateMonthlytoDailyforSeveralYears}}.}

\item{Tx_spline_sim}{daily timeseries (from the first day of \code{year_min_sim} to the last day of \code{year_max_sim}) of averaged maximum temperature which can be obtained by a spline interpolation of monthly mean values (for the generation period). Default is \code{Tx_spline}. See for spline interpolation utilized \code{\link{splineInterpolateMonthlytoDailyforSeveralYears}}.}

\item{onlygeneration}{logical variable. If \code{TRUE} the VAR model \code{varmodel} is given as input and only random generation is done, otherwise (default) is calculated from measured data}

\item{varmodel}{the comprehensinve VAR model as a \code{\link{varest2}} or \code{\link{GPCAvarest2}} S4 object or a \code{NULL} object. If \code{NULL} (default), the comprehensinve VAR is estimated from measured data within the function, otherwise it is given as input and only random generation is done.}

\item{normalize, sample, extremes}{see \code{\link{normalizeGaussian_severalstations}} or \code{\link{setComprehensiveTemperatureGeneratorParameters}}}

\item{type_quantile}{see \code{type} on \code{\link{quantile}}}

\item{option}{integer value. If 1, the generator works with minimun and maximum temperature, if 2 (default) it works with the average value between maximum and minimum temparature and the respective daily thermal range.}

\item{yearly}{logical value. If \code{TRUE} the monthly mean values are calculated for each year from \code{year_min} to \code{year_max} separately. Default is \code{FALSE}.}

\item{yearly_sim}{logical value. If \code{TRUE} the monthly mean values are calculated for each year from \code{year_min_sim} to \code{year_max_sim} separately. Default is \code{yearly}.}

\item{n_GPCA_iteration}{number of iterations of Gaussianization process for data. Default is 0 (no Gaussianization)}

\item{n_GPCA_iteration_residuals}{number of iterations of Gaussianization process for VAR residuals. Default is 0 (no Gaussianization)}

\item{exogen}{data frame or matrix containing the (normalized or not) exogenous variables (predictors) for the recorded (calibration) period. Default is \code{NULL}.}

\item{exogen_sim}{data frame or matrix containing the (normalized or not) exogenous variables (predictors) for the simulation period. Default is \code{NULL}. If it is \code{NULL}, \code{exogen_sim} is set equal to \code{exogen} within the function.}

\item{is_exogen_gaussian}{logical value, If \code{TRUE}, \code{exogen_sim} and \code{exogen} are given as already normalized variables, otherwhise they are not normalized. Default is \code{FALSE}}

\item{exogen_all}{data frame containing exogenous variable formatted like \code{Tx_all} and \code{Tn_all}. Default is \code{NULL}.
It is alternative to \code{exogen} and if it not \code{NULL},\code{is_exogen_gaussian} is automatically set to \code{FALSE}}

\item{exogen_all_col}{vector of considered  columns of \code{exogen_all}. Default is \code{station}.}

\item{nscenario}{number of generated scenarios for daily maximum and minimum temperature}

\item{seed}{seed for stochastic random generation see \code{\link{set.seed}}}

\item{noise}{stochastic noise to add for variabile generation. Default is \code{NULL}. See \code{\link{newVARmultieventRealization}}. Not used in case that \code{nscenario>1}.}

\item{nearPD}{logical. Default is \code{FALSE}. See \code{\link{getVARmodel}}.}
}
\value{
A list of the following variables:

\code{input}   list of variables returned by  \code{\link{setComprehensiveTemperatureGeneratorParameters}}

\code{var}     varest object containing the used VAR model (if useVAR is true), \code{NULL} (otherwise)

\code{output}  list variables returned by  \code{\link{generateTemperatureTimeseries}} (i.e. generated timeseries)
}
\description{
The Comprehensive Temperature Generator
}
\note{
It pre-processes series and generates multi-site temperature fields by using \code{\link{setComprehensiveTemperatureGeneratorParameters}},\code{\link{getVARmodel}} and \code{\link{generateTemperatureTimeseries}}. Detailed examples can be viewed of this function in \href{https://docs.google.com/file/d/0B66otCUk3Bv6V3RPbm1mUG4zVHc/edit}{this presentation}.
}
\examples{

data(trentino)

set.seed(1222) # set the seed for random generations!
year_min <- 1961
year_max <- 1990

year_min_sim <- 1982
year_max_sim <- 1983

n_GPCA_iter <- 5
n_GPCA_iteration_residuals <- 5
p <- 1
vstation <- c("B2440","B6130","B8570","B9100","LAVIO","POLSA","SMICH","T0001",
 "T0010","T0014","T0018","T0032","T0064","T0083","T0090","T0092",
"T0094","T0099","T0102","T0110","T0129","T0139","T0147","T0149",
"T0152","T0157","T0168","T0179","T0189","T0193","T0204","T0210",
"T0211","T0327","T0367","T0373")
## Not Run: the call to ComprehensiveTemperatureGenerator may elapse
## too long time (more than 5 eseconds) and is not executed  by CRAN check.
## Please uncomment the following line to run the example on your own PC.
# generation00 <-ComprehensiveTemperatureGenerator(station=vstation[16],
# Tx_all=TEMPERATURE_MAX,Tn_all=TEMPERATURE_MIN,year_min=year_min,year_max=year_max,
# p=p,n_GPCA_iteration=n_GPCA_iter,n_GPCA_iteration_residuals=n_GPCA_iteration_residuals,
# sample="monthly",year_min_sim=year_min_sim,year_max_sim=year_max_sim)





}
\seealso{
\code{\link{setComprehensiveTemperatureGeneratorParameters}}, \code{\link{generateTemperatureTimeseries}} ,\code{\link{generateTemperatureTimeseries}},\code{\link{splineInterpolateMonthlytoDailyforSeveralYears}}.
}
\author{
Emanuele Cordano, Emanuele Eccel
}
