% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuildTakensVector.R
\name{BuildTakens}
\alias{BuildTakens}
\title{Build the Takens' vectors}
\usage{
BuildTakens(HRVData, embeddingDim, timeLag)
}
\arguments{
\item{HRVData}{Data structure that stores the beats register and information related to it}

\item{embeddingDim}{Integer denoting the dimension in which we shall embed the RR series.}

\item{timeLag}{Integer denoting the number of time steps that will be use to construct the 
Takens' vectors.}
}
\value{
A matrix containing the Takens' vectors (one per row).
}
\description{
This function builds the Takens' vectors of the Non Interpolated RR intervals.
The set  of Takens' vectors is the result of embedding the time series in
 a m-dimensional  space. That is, the \eqn{n^{th}} Takens' vector is defined as 
\deqn{T[n]=\{niRR[n], niRR[n+ timeLag],..., niRR[n+m*timeLag]\}.}
Taken's theorem states that we can then reconstruct an equivalent dynamical 
system to the original one (the 
dynamical system that generated the observed time series) by using the Takens' vectors.
}
\note{
This function is based on the \code{\link[nonlinearTseries]{buildTakens}} function from the 
nonlinearTseries package.
}
\references{
H. Kantz  and T. Schreiber: Nonlinear Time series Analysis (Cambridge university press)
}
