% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regu-est-c.r
\name{mn.aipw}
\alias{mn.aipw}
\title{Augmented inverse probability weighted estimation of population means}
\usage{
mn.aipw(y, tr, fp, fo, off = 0)
}
\arguments{
\item{y}{An \eqn{n} x \eqn{1} vector of outcomes with missing data.}

\item{tr}{An \eqn{n} x \eqn{1} vector of non-missing indicators (=1 if \code{y} is observed or 0 if \code{y} is missing).}

\item{fp}{An \eqn{n} x \eqn{1} vector of fitted propensity scores.}

\item{fo}{An \eqn{n} x \eqn{1} vector of fitted values from outcome regression.}

\item{off}{An offset value (e.g., the true value in simulations) used to calculate the z-statistic.}
}
\value{
\item{one}{The direct IPW estimate of 1.}
\item{ipw}{The ratio IPW estimate.}
\item{or}{The outcome regression estimate.}
\item{est}{The augmented IPW estimate.}
\item{var}{The estimated variance associated with the augmented IPW estimate.}
\item{ze}{The z-statistic for the augmented IPW estimate, compared to \code{off}.}
}
\description{
This function implements augmented inverse probability weighted (IPW) estimation of population means with missing data,
provided both fitted propensity scores and fitted values from outcome regression.
}
\references{
Tan, Z. (2020a) Regularized calibrated estimation of propensity scores with model misspecification and high-dimensional data, \emph{Biometrika}, 107, 137–158.

Tan, Z. (2020b) Model-assisted inference for treatment effects using regularized calibrated estimation with high-dimensional data, \emph{Annals of Statistics}, 48, 811–837.
}
