% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/automixfit.R
\name{automixfit}
\alias{automixfit}
\title{Automatic Fitting of Mixtures of Conjugate Distributions to a Sample}
\usage{
automixfit(sample, Nc = seq(1, 4), k = 6, thresh = -Inf, verbose = FALSE, ...)
}
\arguments{
\item{sample}{Sample to be fitted by a mixture distribution.}

\item{Nc}{Vector of mixture components to try out (default \code{seq(1,4)}).}

\item{k}{Penalty parameter for AIC calculation (default 6)}

\item{thresh}{The procedure stops if the difference of subsequent AIC values
is smaller than this threshold (default -Inf). Setting the threshold to 0
stops \code{automixfit} once the AIC becomes worse.}

\item{verbose}{Enable verbose logging.}

\item{...}{Further arguments passed to \code{\link[=mixfit]{mixfit()}},
including \code{type}.}
}
\value{
As result the best fitting mixture model is returned,
i.e. the model with lowest AIC. All other models are saved in the
attribute \code{models}.
}
\description{
Fitting a series of mixtures of conjugate distributions to a
\code{sample}, using Expectation-Maximization (EM). The number of
mixture components is specified by the vector \code{Nc}. First a
\code{Nc[1]} component mixture is fitted, then a \code{Nc[2]}
component mixture, and so on. The mixture providing the best AIC
value is then selected.
}
\details{
The \code{type} argument specifies the distribution of
the mixture components, and can be a normal, beta or gamma
distribution.

The penalty parameter \code{k} is 2 for the standard AIC
definition. \emph{Collet (2003)} suggested to use values in the
range from 2 to 6, where larger values of \code{k} penalize more
complex models. To favor mixtures with fewer components a value of
6 is used as default.
}
\examples{
# random sample of size 1000 from a mixture of 2 beta components
bm <- mixbeta(beta1 = c(0.4, 20, 90), beta2 = c(0.6, 35, 65))
bmSamp <- rmix(bm, 1000)

# fit with EM mixture models with up to 10 components and stop if
# AIC increases
bmFit <- automixfit(bmSamp, Nc = 1:10, thresh = 0, type = "beta")
bmFit

# advanced usage: find out about all discarded models
bmFitAll <- attr(bmFit, "models")

sapply(bmFitAll, AIC, k = 6)

}
\references{
Collet D.
\emph{Modeling Survival Data in Medical Research}.
2003; Chapman and Hall/CRC.
}
