% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base-Singleton.R
\name{Singleton}
\alias{Singleton}
\title{Singleton}
\description{
Enforces a single instance of a class and provides a global access point.
}
\details{
This is an abstract base class. Instantiating \code{Singleton} directly triggers an error.
Classes inheriting from \code{Singleton} share a single instance.
}
\examples{
# See more examples at <https://tidylab.github.io/R6P/articles>
address <- function(x) sub("<environment: (.*)>", "\\\\1", capture.output(x))

# In this example we implement a `Counter` that inherits the qualities of Singleton
Counter <- R6::R6Class("Counter", inherit = R6P::Singleton, public = list(
  count = 0,
  add_1 = function() {
    self$count <- self$count + 1
    invisible(self)
  }
))

# Whenever we call the constructor on `Counter`, we always get the exact same instance:
counter_A <- Counter$new()
counter_B <- Counter$new()

identical(counter_A, counter_B, ignore.environment = FALSE)

# The two objects are equal and located at the same address; thus, they are the same object.

# When we make a change in any of the class instances, the rest are changed as well.

# How many times has the counter been increased?
counter_A$count

# Increase the counter by 1
counter_A$add_1()

# How many times have the counters been increased?
counter_A$count
counter_B$count

}
\seealso{
Other base design patterns: 
\code{\link{NullObject}()},
\code{\link{ValueObject}()}
}
\concept{base design patterns}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Singleton-new}{\code{Singleton$new()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Singleton-new"></a>}}
\if{latex}{\out{\hypertarget{method-Singleton-new}{}}}
\subsection{Method \code{new()}}{
Create or retrieve an object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Singleton$new()}\if{html}{\out{</div>}}
}

}
}
