% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peer.ces.R
\name{cespeer.data}
\alias{cespeer.data}
\title{Compute the CES Social Norm}
\usage{
cespeer.data(y, Glist, rho)
}
\arguments{
\item{y}{A vector of outcomes used to compute the social norm.}

\item{Glist}{The adjacency matrix. For networks consisting of multiple subnets (e.g., schools), \code{Glist} must be a list of subnets, with the \code{m}-th element being an \eqn{n_m \times n_m} adjacency matrix, where \eqn{n_m} is the number of nodes in the \code{m}-th subnet.}

\item{rho}{The CES substitution parameter.}
}
\value{
A four-column matrix with the following columns:
\item{\code{y}}{The outcome;}
\item{\code{ces(y, rho)}}{The CES social norm;}
\item{\code{d[ces(y, rho)]}}{The first derivative of the social norm;}
\item{\code{dd[ces(y, rho)]}}{The second derivative of the social norm.}
}
\description{
\code{cespeer.data} computes the CES social norm, along with the first and second derivatives of the CES social norm with respect to the substitution parameter \eqn{\rho}.
}
