% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcHLMRel.R
\name{calcHLMRel}
\alias{calcHLMRel}
\title{Calculate reliability using a hierarchical linear regression model}
\usage{
calcHLMRel(
  df = NULL,
  model = NULL,
  entity = "entity",
  y = "y",
  ctrPerf = controlPerf()
)
}
\arguments{
\item{df}{observation-level data; if null, will use the dataframe from the model object}

\item{model}{model; if null, will use an unadjusted model}

\item{entity}{data column containing the accountable entity identifier}

\item{y}{data column containing the outcome variable}

\item{ctrPerf}{parameters to control performance measure calculation}
}
\value{
A list containing:
\itemize{
\item \code{fit}: fitted model
\item \code{entity}: list of entities
\item \code{n}: entity sample sizes
\item \code{var.b}: between-entity variance
\item \code{var.w}: within-entity variance
\item \code{est.HLM}: entity-level reliability
}
}
\description{
This function estimates reliability using a hierarchical linear regression model with random intercepts for each accountable entity.
}
\details{
Hierarchical linear regression models are fit using \code{lme4::lmer()}.
}
\examples{
# Simulate data
df <- simulateData(n.entity = 50, n.obs = 100, mu = 12, r = .7, data.type = 'normal')

# Calculate reliability
out <- calcHLMRel(df = df, entity = 'entity', y = 'y')
summary(out$est.HLM)

# Plot reliability
plot(out$n, out$est.HLM)

}
\references{
Nieser KJ, Harris AH. Comparing methods for assessing the reliability of health care quality measures. Statistics in Medicine. 2024 Oct 15;43(23):4575-94.
}
\author{
Kenneth Nieser (nieser@stanford.edu)
}
