% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qol_miss.R
\name{qol_miss}
\alias{qol_miss}
\title{Cancer Quality of Life data analysis with missing values.}
\usage{
qol_miss(x)
}
\arguments{
\item{x}{A data frame with ID, Q1, Q2,..., Q30 columns along with other columns if data is available.}
}
\value{
A data frame by replacing the columns 'Q1','Q2',...,'Q30' by the domain-based scale scores.
}
\description{
Creates a dataset containing the domain-based scale scores using
the data from Quality of Life questionnaire
}
\details{
Calculates the domain-based scale scores using the data from
Quality of Life questionnaire

miss_patient function inputs a dataset in which the information of some patients
are completely missing. The information of these patients are omitted from the data
and only the columns named 'Q1','Q2',...,'Q30' are extracted.

Using each of the 30 columns, the Raw Score is computed, and one column is obtained containing
the Raw Score for each patient.

Further, using each of the Raw Scores, three domain-based Scale Scores are computed,
they are, Global Scales Score, Functional Scales Score and Symptoms Scales Score.

Thus, the columns 'Q1','Q2',...,'Q30' are replaced by the domain-based scale scores,
which is obtained as the output.

qol_miss(x)

1) Subject ID column should be named as 'ID'.

2) Each question column should be named as 'Q1' for data from question 1,
'Q2' for data from question 2, and so on until 'Q30' for data from question 30.

3) Only those data can be used which contains no information for some patients, that is, some rows contain only NA.

4) Data may contain more variables, such as, Age, Gender, etc.

x - A data frame with ID, Q1, Q2,..., Q30 columns along with other columns if data
is available.

rs - A matrix containing the Raw Score computed using all Q1 to Q30 data for each
patient. The RS(a) function is used in this case.

fs - A matrix containing the Functional Scale Scores computed using all Q1 to Q30
data for each patient. The FS(a,b) function is used in this case.

ss_gs - A matrix containing the Global Scale Scores computed using all Q1 to Q30
data for each patient. The SS_GS(a,b) function is used in this case.

final_data - A data frame formed by replacing the columns 'Q1','Q2',...,'Q30' by
the domain-based scale scores.
}
\examples{
##
data(patient_miss)
qol_miss(patient_miss)
##

}
\references{
QoLMiss: Package for Repeatedly measured Quality of Life of Cancer Patients Data
}
\seealso{
https://github.com/apstat/QoLMiss-Package
}
\author{
Atanu Bhattacharjee and Ankita Pal
}
