% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ovc_qol.R
\name{ovc_qol}
\alias{ovc_qol}
\title{Calculates the domain-based scale scores using the data of QLQ-OV28.}
\usage{
ovc_qol(x)
}
\arguments{
\item{x}{A data frame with ID, OV_Q31,OV_Q32,...,OV_Q58 columns along with other columns if data is available.}
}
\value{
A data frame by replacing the columns 'OV_Q31','OV_Q32',...,'OV_Q58' by the domain-based scale scores.
}
\description{
Creates a dataset containing the domain-based scale scores using
the data from QLQ-OV28
}
\details{
Calculates the domain-based scale scores using the data of QLQ-OV28

brc_miss function inputs either a dataset containing missing information, represented as,
9 or 99 or NA or a data not containing any missing information. It extracts only the columns
named 'OV_Q31','OV_Q32',...,'OV_Q58' and replaces the missing data with the minimum value of the particular question.

Using each of the 30 columns, the Raw Score is computed, and one column is obtained containing
the Raw Score for each patient.

Further, using each of the Raw Scores, three domain-based Scale Scores are computed,
they are, Global Scales Score, Functional Scales Score and Symptoms Scales Score.

Thus, the columns 'OV_Q31','OV_Q32',...,'OV_Q58' are replaced by the domain-based scale scores,
which is obtained as the output.

ovc_qol(x)

1) Subject ID column should be named as 'ID'.

2) Each question column should be named as 'OV_Q31' for data from question 31,
'OV_Q32' for data from question 32, and so on until 'OV_Q58' for data from question 58

3) Data may contain more variables, such as, Age, Gender, etc.

x - A data frame with ID, OV_Q31,OV_Q32,...,OV_Q58 columns along with other columns if data
is available.

rs - A matrix containing the Raw Score computed using all OV_Q31 to OV_Q58 data for each
patient. The RS(a) function is used in this case.

ss - A matrix containing the Global Scale Scores computed using all OV_Q31 to OV_Q58
data for each patient. The SS(a,b) function is used in this case.

final_data - A data frame formed by replacing the columns 'OV_Q31','OV_Q32',...,'OV_Q58' by
the domain-based scale scores.
}
\examples{
##
data(ovc_df)
ovc_qol(ovc_df)
data(ovc_df_miss)
ovc_qol(ovc_df_miss)
##

}
\references{
QoLMiss: Package for Repeatedly measured Quality of Life of Cancer Patients Data
}
\seealso{
https://github.com/apstat/QoLMiss-Package
}
\author{
Atanu Bhattacharjee and Ankita Pal
}
