% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_study_data}
\alias{get_study_data}
\title{Get the Observations Data of the Current Active Study}
\usage{
get_study_data()
}
\value{
A data frame containing the observation data for the active study, or \code{NULL} 
if no data is available.
}
\description{
Retrieves the observations data (e.g., measurements, variables) for the active study, 
which must be set using the \code{\link{set_study}} function.
}
\examples{
if (interactive()) {
  set_qbms_config("https://bms.icarda.org/ibpworkbench")
  login_bms()
  set_crop("wheat")
  set_program("Wheat International Nurseries")
  set_trial("IDYT39")
  set_study("IDYT39 Environment Number 9")
  data <- get_study_data()
  head(data)
}

}
\seealso{
\code{\link{login}}, \code{\link{set_crop}}, \code{\link{set_program}}, 
\code{\link{set_trial}}, \code{\link{set_study}} for related study operations.
}
\author{
Khaled Al-Shamaa (\email{k.el-shamaa@cgiar.org})
}
