% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PxWebApi2.R
\name{meta_frames}
\alias{meta_frames}
\title{Structured PxWebApi v2 metadata}
\usage{
meta_frames(url_or_tableid, url_type = "ssb")
}
\arguments{
\item{url_or_tableid}{A table id, a PxWebApi v2 URL to data or metadata,
or previously retrieved metadata.}

\item{url_type}{Currently two possibilities: "ssb" (Norwegian) or "ssb_en" (English).}
}
\value{
A named list of data frames. Additional metadata is stored as attributes
on the data frames.
The data URL is stored in the comment attribute of the returned object.
}
\description{
Structures selected parts of table metadata into data frames.
}
\details{
Metadata related to the categories of dimensional variables are returned
as data frames, with additional information stored as attributes.
}
\examples{
metaframes <- meta_frames(7459, url_type = "ssb_en")

names(metaframes)

metaframes[["ContentsCode"]]
metaframes[["Kjonn"]]

# Extra information stored as an attribute on a data frame
attr(metaframes[["Region"]], "extra")[[1]][[1]]

# Code list information as a data frame stored as another attribute
attr(metaframes[["Region"]], "code_lists")

# Information about elimination possibilities
attr(metaframes[["Region"]], "elimination")
attr(metaframes[["ContentsCode"]], "elimination")
sapply(metaframes, attr, "elimination") # elimination info for all variables

}
