% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PxWebApi2.R
\name{meta_data}
\alias{meta_data}
\title{PxWebApi v2 metadata for a table}
\usage{
meta_data(url_or_tableid, url_type = "ssb")
}
\arguments{
\item{url_or_tableid}{Either a numeric table id or a PxWebApi v2 URL to data.
When a data URL is supplied, it is internally converted to a metadata URL.}

\item{url_type}{Currently two possibilities: "ssb" (Norwegian) or "ssb_en" (English).}
}
\value{
A list containing table metadata read by \code{\link[jsonlite:read_json]{jsonlite::read_json()}} after internal URL adjustments via \code{\link[=ensure_json_stat2]{ensure_json_stat2()}}.
The data URL is stored in the comment attribute of the returned object.
}
\description{
Retrieves metadata for a table using the PxWebApi v2 endpoint and returns it
as an R object via \code{\link[jsonlite:read_json]{jsonlite::read_json()}}.
}
\examples{
metadata1 <- meta_data(8991, url_type = "ssb_en")
metadata2 <- meta_data(
  "https://statistikdatabasen.scb.se/api/v2/tables/TAB1525/data?lang=en"
)

print(metadata1[1:4])
print(metadata2[1:4])
}
