% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{ols}
\alias{ols}
\title{Ordinary Least Square regression}
\usage{
ols(data,y,x,alpha=0.025,verbose=TRUE)
}
\arguments{
\item{data}{Dataset used to estimated the coefficients}

\item{y}{name of the dependent variable}

\item{x}{name or a vector of names of the independent variables}

\item{alpha}{confedence level}

\item{verbose}{logical, if TRUE, the table will be printed}
}
\value{
coefficients of the linear model, or a table with the coefficients, standard errors, t-values, p-values and confidence intervals
}
\description{
This is a function that estimates coefficients for a linear model using Ordinary Least Squares (OLS) regression.
}
\examples{
df = data.frame("hours"=c(1, 2, 4, 5, 5, 6, 6, 7, 8, 10, 11, 11, 12, 12, 14),
"score"=c(64, 66, 76, 73, 74, 81, 83, 82, 80, 88, 84, 82, 91, 93, 89))
ols(df,"score","hours")
}
