% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqplot.R
\name{freqplot}
\alias{freqplot}
\title{Frequency plot for a lagphase fit}
\usage{
freqplot(
  fit1,
  fit2 = NULL,
  fit3 = NULL,
  fit4 = NULL,
  xlab = "Year",
  ylab = "Frequency",
  main = fit1$name,
  cols = 2:5,
  ...
)
}
\arguments{
\item{fit1, fit2, fit3, fit4}{"lagphase" fit objects to plot}

\item{xlab}{Label for the $x$-axis}

\item{ylab}{Label for the $y$-axis}

\item{main}{Title of the plot}

\item{cols}{Colors to be used to draw the lines}

\item{...}{(optional) parameters to pass to plot}
}
\value{
Produces a plot of observed and predicted frequencies for the species against year
}
\description{
Frequency plot for a lagphase fit
}
\examples{
Species = unique(fdata$Species) #List of all species
fit1 = lagfit(fdata, yeardata, species=Species[1])
freqplot(fit1$fit)
}
