% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Poisson-Multinomial_functions.R
\name{rpmd}
\alias{rpmd}
\title{Poisson-Multinomial Distribution Random Number Generator}
\usage{
rpmd(pmat, s = 1)
}
\arguments{
\item{pmat}{An \eqn{\rm n \times m} success probability matrix, where \eqn{\rm n} is the number of independent trials and \eqn{\rm m} is the number of categories.
Each row of pmat contains the success probabilities for the corresponding
trial, and each row adds up to 1.}

\item{s}{The number of samples to be generated.}
}
\value{
An \eqn{s \times m} matrix of samples, each row stands for one sample from the PMD with success probability matrix \code{pmat}.
}
\description{
Generates random samples from the PMD specified by the success probability matrix.
}
\examples{
pp <- matrix(c(.1, .1, .1, .7, .1, .3, .3, .3, .5, .2, .1, .2), nrow = 3, byrow = TRUE)
 
rpmd(pmat = pp, s = 5)

}
