#' PhenoSpectra Internal Setup
#'
#' Handles automatic environment setup and global variable registration when the package is loaded.
#' @name zzz
#' @keywords internal
#' @importFrom utils installed.packages install.packages globalVariables
#' @importFrom dplyr mutate group_by summarise ungroup select everything left_join coalesce across all_of starts_with where if_any cur_column case_when relocate bind_rows
#' @importFrom tidyr pivot_longer
#' @importFrom readxl read_xlsx
#' @importFrom writexl write_xlsx
#' @importFrom rlang sym
#' @importFrom magrittr %>%
#' @examples
#' # Example usage:
#' # Automatically run when the package is loaded, but can be manually called if needed
#' setup_environment()

# Register global variables to avoid NSE warnings
utils::globalVariables(c(
  "MissingCount", "OutlierCount", "SDS", "Sample", "Scan.date",
  "Scan.time", "Unique_Variable", "Variable", "fdr_p_value",
  "p.value", "term", "timestamp", "treatment"
))

#' Setup Environment Function
#'
#' This function installs missing packages required by the PhenoSpectra package.
#' @name setup_environment
#' @export
#' @examples
#' # Run to manually install missing packages
#' setup_environment()
setup_environment <- function() {
  requiredPackages <- c("dplyr", "readxl", "writexl", "tidyr", "rlang", "magrittr", "broom", "utils")
  
  # Install missing packages
  for (pkg in requiredPackages) {
    if (!requireNamespace(pkg, quietly = TRUE)) {
      warning(paste("Package", pkg, "is not installed. Please install it manually using install.packages()."))
    }
  }
}

#' .onLoad Function
#'
#' Automatically runs when the package is loaded and sets up the environment.
#' @name .onLoad
#' @keywords internal
.onLoad <- function(libname, pkgname) {
  setup_environment()
}
