% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LP_SPAS_fit.R
\name{LP_SPAS_fit}
\alias{LP_SPAS_fit}
\title{Fit a Stratified-Petersen SPAS model.}
\usage{
LP_SPAS_fit(
  data,
  model.id = "Base model",
  autopool = FALSE,
  row.pool.in = NULL,
  col.pool.in = NULL,
  min.released = 100,
  min.inspected = 50,
  min.recaps = 50,
  min.rows = 1,
  min.cols = 1,
  quietly = FALSE
)
}
\arguments{
\item{data}{Data frame containing the variables:
\itemize{
\item \strong{cap_hist} Capture history (see details below)
\item \strong{freq} Number of times this capture history was observed
}
plus any other covariates (e.g. discrete strata and/or continuous covariates) to be used
in the model fitting.}

\item{model.id}{Character string identifying the name of the model.}

\item{autopool}{Should the automatic pooling algorithms be used.
Give more details here on these rule work.}

\item{row.pool.in, col.pool.in}{Vectors (character/numeric) of length s and t respectively. These identify the rows/columns to be pooled before the analysis is done.
The vectors consists of entries where pooling takes place if the entries are the same. For example, if s=4, then
row.pool.in = c(1,2,3,4) implies no pooling because all entries are distinct; row.pool.in=c("a","a","b","b") implies that the
first two rows will be pooled and the last two rows will be pooled. It is not necessary that row/columns be continuous to be pooled, but
this is seldom sensible. A careful choice of pooling labels helps to remember what as done, e.g. row.pool.in=c("123","123","123","4") indicates
that the first 3 rows are pooled and the 4th row is not pooled. Character entries ensure that the resulting matrix is sorted properly (e.g. if
row.pool.in=c(123,123,123,4), then the same pooling is done, but the matrix rows are sorted rather strangely.}

\item{min.released}{Minimum number of releases in a pooled row}

\item{min.inspected}{Minimum number of inspections in a pooled column}

\item{min.recaps}{Minimum number of recaptures before any rows can be pooled}

\item{min.rows, min.cols}{Minimum number or rows and columns after pooling}

\item{quietly}{Suppress all console messages that occur during the fit. This includes the progress bar
when a model that requires MCMC is fit (\emph{LP_BTSPAS_fit_Diag} and \emph{LP_BTSPAS_fit_NonDiag}), or
a trace of the likelihood during the fit (\emph{LP_SPAS_fit}).}
}
\value{
An list object of class \emph{LP_SPAS_fit} with abundance estimates and other information with the following elements
\itemize{
\item \strong{summary} A data frame with the model for the capture probabilities;
the conditional log-likelihood; the number of parameters; the number of parameters, condition factor of the data matrix, and method used to fit the model
\item \strong{data} A data frame with the raw data used in the fit
\item \strong{fit} Results of the fit including the estimates, SE, vcov, etc.
\item \strong{row.pool.in}, \strong{col.pool.in}, \strong{autopool} Arguments used in the fit to indicate row, column, or automatic pooling used in the fit.
\item \strong{datetime} Date and time the fit was done
}

After the fit is complete, use the \emph{LP_SPAS_est()} function to extract the estimates, and the SPAS::SPAS.print.model() function to get a nicely
formatted report on the fit.
}
\description{
This function is a wrapper to fits a SPAS model(Schwarz, 2023; Schwarz and Taylor, 1998). Consult the SPAS package for more details.
}
\examples{
data(data_spas_harrison)

fit <- Petersen::LP_SPAS_fit(data=data_spas_harrison,
                              model.id="Pooling rows 5/6",
                              row.pool.in=c(1,2,3,4,56,56),
                              col.pool.in=c(1,2,3,4,5,6),quietly=TRUE)
fit$summary
est <- Petersen::LP_SPAS_est(fit)
est$summary

# make a nice report using the SPAS package functions
SPAS::SPAS.print.model(fit$fit)

}
\references{
Schwarz CJ (2023). \emph{SPAS: Stratified-Petersen Analysis System}.
R package version 2023.3.31, \url{https://CRAN.R-project.org/package=SPAS}.

Schwarz, C. J. and Taylor, C. G. (1998). The use of the
stratified-Petersen estimator in fisheries management: estimating the
number of pink salmon (Oncorhynchus gorbuscha) that spawn in the Fraser River.
Canadian Journal of Fisheries and Aquatic Sciences 55, 281-297.
https://doi.org/10.1139/f97-238
}
