#' @title Types of households by population and sex, rural/urban
#' @name   TABLE_21
#' @docType data
#' @keywords datasets
#' @usage data(TABLE_21)
#' @description \code{TABLE_21} Types of households by population and sex, rural/urban
#' @format A \code{data.table} and  \code{data.frame}.
#' \describe{
#'   \item{\code{PROVINCE}}{PROVINCE}
#'   \item{\code{DIVISION}}{DIVISION}
#'   \item{\code{DISTRICT}}{DISTRICT}
#'   \item{\code{TEHSIL}}{TEHSIL}
#'   \item{\code{ADMIN_UNIT}}{ADMIN UNIT}
#'   \item{\code{REGION}}{REGION}
#'   \item{\code{TYPE_OF_HOUSING_UNITS}}{TYPE OF HOUSING UNITS}
#'   \item{\code{ALL_SEXES}}{ALL SEXES}
#'   \item{\code{MALE}}{MALE}
#'   \item{\code{FEMALE}}{FEMALE}
#'   \item{\code{TGEND}}{TGEND}
#'   \item{\code{HOUSING_UNITS_TOTAL}}{HOUSING UNITS TOTAL}
#'   \item{\code{HOUSING_UNITS_PCT}}{HOUSING UNITS PCT}
#'        }
#'
#' @author Muhammad Yaseen (\email{myaseen208@@gmail.com})
#'
#' @references \enumerate{
#' \item Pakistan Population Census 2023 (\url{https://www.pbs.gov.pk/}).
#'  }
#' 
#' @seealso
#'    \code{\link{PakPC2023PakDiv}}
#'  , \code{\link{PakPC2023PakDist}}
#'
#' @import DT htmltools
#' 
#' @examples
#' data(TABLE_21)
NULL
