#' @title Population (15 years and above) by relationship to the head of household, sex, marital status and rural/urban
#' @name   TABLE_07
#' @docType data
#' @keywords datasets
#' @usage data(TABLE_07)
#' @description \code{TABLE_07} Population (15 years and above) by relationship to the head of household, sex, marital status and rural/urban
#' @format A \code{data.table} and  \code{data.frame}.
#' \describe{
#'   \item{\code{PROVINCE}}{PROVINCE}
#'   \item{\code{DISTRICT}}{DISTRICT}
#'   \item{\code{RELATION_TO_HH_HEAD}}{RELATION TO HH HEAD}
#'   \item{\code{MARITAL_STATUS}}{MARITAL STATUS}
#'   \item{\code{FEMALE_OVERALL}}{FEMALE OVERALL}
#'   \item{\code{MALE_OVERALL}}{MALE OVERALL}
#'   \item{\code{TGEND_OVERALL}}{TRANSGENDER OVERALL}
#'   \item{\code{FEMALE_RURAL}}{FEMALE RURAL}
#'   \item{\code{MALE_RURAL}}{MALE RURAL}
#'   \item{\code{TGEND_RURAL}}{TRANSGENDER RURAL}
#'   \item{\code{FEMALE_URBAN}}{FEMALE URBAN}
#'   \item{\code{MALE_URBAN}}{MALE URBAN}
#'   \item{\code{TGEND_URBAN}}{TRANSGENDER URBAN}
#'        }
#'
#' @author Muhammad Yaseen (\email{myaseen208@@gmail.com})
#'
#' @references \enumerate{
#' \item Pakistan Population Census 2023 (\url{https://www.pbs.gov.pk/}).
#'  }
#' 
#' @seealso
#'    \code{\link{PakPC2023PakDiv}}
#'  , \code{\link{PakPC2023PakDist}}
#'
#' @import DT htmltools
#' 
#' @examples
#' data(TABLE_07)
NULL
