% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palm.txt.get.reference.R
\name{palm.txt.get.reference}
\alias{palm.txt.get.reference}
\title{Get references based on a query using the Google PaLM 2 text model}
\usage{
palm.txt.get.reference(
  model.parameter,
  prompt,
  source.type = "articles",
  source.date = "most recent",
  n.source = 5,
  citation.style = "APA7",
  temperature = 0.7,
  maxOutputTokens = 1024,
  topP = 0.95,
  topK = 40,
  htUnspecified = "meda",
  htDerogatory = "meda",
  htToxicity = "meda",
  htViolence = "meda",
  htSexual = "meda",
  htMedical = "meda",
  htDangerous = "meda"
)
}
\arguments{
\item{model.parameter}{A character vector containing the API key, model version, and proxy status. Model version and type
are specified by Google. See function \code{\link{palm.connect}} for detail.}

\item{prompt}{A character string representing the code snippet for explanation. The length of the code snippet should be between
1 and 8196 characters, inclusive.}

\item{source.type}{A character string specifying the type of sources to search for (default: "articles").}

\item{source.date}{A character string specifying the date range for the sources (default: "most recent").}

\item{n.source}{An integer value specifying the number of sources to retrieve (default: 5).}

\item{citation.style}{A character string specifying the citation style for the references (default: "APA7").}

\item{temperature}{A numeric value between 0.0 and 1.0, inclusive (default: 0.7). Controls the randomness of the generated references.
A higher value (e.g., 0.9) results in more creative responses, while a lower value (e.g., 0.3) produces more straightforward references.}

\item{maxOutputTokens}{An integer value (default: 1024). Specifies the maximum number of tokens to include in the generated references.}

\item{topP}{A numeric value between (default: 0.95). Defines the maximum cumulative probability of tokens considered when sampling.
It controls the diversity of the references generated.}

\item{topK}{An integer value between (default: 40). Sets the maximum number of tokens to consider when sampling.}

\item{htUnspecified}{Safety setting threshold for unspecified harm. The default threshold is "meda". Valid options are as follows.

\describe{
   \item{"unsp"}{HARM_BLOCK_THRESHOLD_UNSPECIFIED}
   \item{"lowa"}{BLOCK_LOW_AND_ABOVE}
   \item{"meda"}{BLOCK_MEDIUM_AND_ABOVE}
   \item{"high"}{BLOCK_ONLY_HIGH}
   \item{"none"}{BLOCK_NONE}
}}

\item{htDerogatory}{Safety setting threshold for derogatory harm. The default threshold is "meda". Valid options are as follows.

\describe{
   \item{"unsp"}{HARM_BLOCK_THRESHOLD_UNSPECIFIED}
   \item{"lowa"}{BLOCK_LOW_AND_ABOVE}
   \item{"meda"}{BLOCK_MEDIUM_AND_ABOVE}
   \item{"high"}{BLOCK_ONLY_HIGH}
   \item{"none"}{BLOCK_NONE}
}}

\item{htToxicity}{Safety setting threshold for toxicity harm. The default threshold is "meda". Valid options are as follows.

\describe{
   \item{"unsp"}{HARM_BLOCK_THRESHOLD_UNSPECIFIED}
   \item{"lowa"}{BLOCK_LOW_AND_ABOVE}
   \item{"meda"}{BLOCK_MEDIUM_AND_ABOVE}
   \item{"high"}{BLOCK_ONLY_HIGH}
   \item{"none"}{BLOCK_NONE}
}}

\item{htViolence}{Safety setting threshold for violence harm. The default threshold is "meda". Valid options are as follows.

\describe{
   \item{"unsp"}{HARM_BLOCK_THRESHOLD_UNSPECIFIED}
   \item{"lowa"}{BLOCK_LOW_AND_ABOVE}
   \item{"meda"}{BLOCK_MEDIUM_AND_ABOVE}
   \item{"high"}{BLOCK_ONLY_HIGH}
   \item{"none"}{BLOCK_NONE}
}}

\item{htSexual}{Safety setting threshold for sexual harm. The default threshold is "meda". Valid options are as follows.

\describe{
   \item{"unsp"}{HARM_BLOCK_THRESHOLD_UNSPECIFIED}
   \item{"lowa"}{BLOCK_LOW_AND_ABOVE}
   \item{"meda"}{BLOCK_MEDIUM_AND_ABOVE}
   \item{"high"}{BLOCK_ONLY_HIGH}
   \item{"none"}{BLOCK_NONE}
}}

\item{htMedical}{Safety setting threshold for medical harm. The default threshold is "meda". Valid options are as follows.

\describe{
   \item{"unsp"}{HARM_BLOCK_THRESHOLD_UNSPECIFIED}
   \item{"lowa"}{BLOCK_LOW_AND_ABOVE}
   \item{"meda"}{BLOCK_MEDIUM_AND_ABOVE}
   \item{"high"}{BLOCK_ONLY_HIGH}
   \item{"none"}{BLOCK_NONE}
}}

\item{htDangerous}{Safety setting threshold for dangerous harm. The default threshold is "meda". Valid options are as follows.

\describe{
   \item{"unsp"}{HARM_BLOCK_THRESHOLD_UNSPECIFIED}
   \item{"lowa"}{BLOCK_LOW_AND_ABOVE}
   \item{"meda"}{BLOCK_MEDIUM_AND_ABOVE}
   \item{"high"}{BLOCK_ONLY_HIGH}
   \item{"none"}{BLOCK_NONE}
}}
}
\value{
A character string containing the generated references based on the provided query and parameters.
}
\description{
This function sends a query to the Google PaLM 2 text model and generates a list of references based on the query. It allows customization of the
generated references and supports various citation styles and source types.
}
\details{
This function interacts with the Google PaLM model by sending a query to find references. It allows you to customize the generated
references by specifying the number of sources, citation style, source type, date range, and safety settings.

If the function is successful, it returns a character vector containing the generated references. If an error occurs during the
API request, it will stop execution and provide an error message.

The `model.parameter` argument should be a character vector with the API key, model version, and model type provided by
Google. You can obtain this information by following the instructions provided by Google for using the PaLM API.

The safety settings control the content's safety level based on different harm categories. Harm thresholds are
specified as per Google's guidelines and can be customized to control the content generated.
}
\examples{
\dontrun{
# Connect to the model, replace API_KEY with your api key
palm.model = palm.connect("v1beta2",
                          "API_KEY",
                          FALSE)

correct.text = palm.txt.get.reference(palm.model,
                                      "H5N1 in the United States")
cat(correct.text)
}

}
\seealso{
\href{https://palmr.ly.gd.edu.kg/documentation/}{PaLMr - Documentation}

\href{https://ai.google.dev/api/rest/v1beta/SafetySetting}{Safety Setting - Google AI for Developers}

\href{https://ai.google.dev/api/rest/v1beta/HarmCategory}{HarmCategory - Google AI for Developers}
}
