% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palm.txt.fix.grammar.R
\name{palm.txt.fix.grammar}
\alias{palm.txt.fix.grammar}
\title{Fix grammar and rewrite text using the Google PaLM 2 text model}
\usage{
palm.txt.fix.grammar(
  model.parameter,
  prompt,
  temperature = 0.7,
  maxOutputTokens = 1024,
  topP = 0.95,
  topK = 40,
  htUnspecified = "meda",
  htDerogatory = "meda",
  htToxicity = "meda",
  htViolence = "meda",
  htSexual = "meda",
  htMedical = "meda",
  htDangerous = "meda"
)
}
\arguments{
\item{model.parameter}{A character vector containing the API key, model version, and proxy status. Model version and type
are specified by Google. See function \code{\link{palm.connect}} for detail.}

\item{prompt}{A character string representing the code snippet for explanation. The length of the code snippet should be between
1 and 8196 characters, inclusive.}

\item{temperature}{A numeric value between 0.0 and 1.0, inclusive (default: 0.7). Controls the randomness of the generated text.
A higher value (e.g., 0.9) results in more creative responses, while a lower value (e.g., 0.3) produces more straightforward text.}

\item{maxOutputTokens}{An integer value (default: 1024). Specifies the maximum number of tokens to
include in the generated text.}

\item{topP}{A numeric value (default: 0.95). Defines the maximum cumulative probability of tokens
considered when sampling. It controls the diversity of the text generated.}

\item{topK}{An integer value (default: 40). Sets the maximum number of tokens to consider
when sampling.}

\item{htUnspecified}{Safety setting threshold for unspecified harm. The default threshold is "meda". Valid options are as follows.

\describe{
   \item{"unsp"}{HARM_BLOCK_THRESHOLD_UNSPECIFIED}
   \item{"lowa"}{BLOCK_LOW_AND_ABOVE}
   \item{"meda"}{BLOCK_MEDIUM_AND_ABOVE}
   \item{"high"}{BLOCK_ONLY_HIGH}
   \item{"none"}{BLOCK_NONE}
}}

\item{htDerogatory}{Safety setting threshold for derogatory harm. The default threshold is "meda". Valid options are as follows.

\describe{
   \item{"unsp"}{HARM_BLOCK_THRESHOLD_UNSPECIFIED}
   \item{"lowa"}{BLOCK_LOW_AND_ABOVE}
   \item{"meda"}{BLOCK_MEDIUM_AND_ABOVE}
   \item{"high"}{BLOCK_ONLY_HIGH}
   \item{"none"}{BLOCK_NONE}
}}

\item{htToxicity}{Safety setting threshold for toxicity harm. The default threshold is "meda". Valid options are as follows.

\describe{
   \item{"unsp"}{HARM_BLOCK_THRESHOLD_UNSPECIFIED}
   \item{"lowa"}{BLOCK_LOW_AND_ABOVE}
   \item{"meda"}{BLOCK_MEDIUM_AND_ABOVE}
   \item{"high"}{BLOCK_ONLY_HIGH}
   \item{"none"}{BLOCK_NONE}
}}

\item{htViolence}{Safety setting threshold for violence harm. The default threshold is "meda". Valid options are as follows.

\describe{
   \item{"unsp"}{HARM_BLOCK_THRESHOLD_UNSPECIFIED}
   \item{"lowa"}{BLOCK_LOW_AND_ABOVE}
   \item{"meda"}{BLOCK_MEDIUM_AND_ABOVE}
   \item{"high"}{BLOCK_ONLY_HIGH}
   \item{"none"}{BLOCK_NONE}
}}

\item{htSexual}{Safety setting threshold for sexual harm. The default threshold is "meda". Valid options are as follows.

\describe{
   \item{"unsp"}{HARM_BLOCK_THRESHOLD_UNSPECIFIED}
   \item{"lowa"}{BLOCK_LOW_AND_ABOVE}
   \item{"meda"}{BLOCK_MEDIUM_AND_ABOVE}
   \item{"high"}{BLOCK_ONLY_HIGH}
   \item{"none"}{BLOCK_NONE}
}}

\item{htMedical}{Safety setting threshold for medical harm. The default threshold is "meda". Valid options are as follows.

\describe{
   \item{"unsp"}{HARM_BLOCK_THRESHOLD_UNSPECIFIED}
   \item{"lowa"}{BLOCK_LOW_AND_ABOVE}
   \item{"meda"}{BLOCK_MEDIUM_AND_ABOVE}
   \item{"high"}{BLOCK_ONLY_HIGH}
   \item{"none"}{BLOCK_NONE}
}}

\item{htDangerous}{Safety setting threshold for dangerous harm. The default threshold is "meda". Valid options are as follows.

\describe{
   \item{"unsp"}{HARM_BLOCK_THRESHOLD_UNSPECIFIED}
   \item{"lowa"}{BLOCK_LOW_AND_ABOVE}
   \item{"meda"}{BLOCK_MEDIUM_AND_ABOVE}
   \item{"high"}{BLOCK_ONLY_HIGH}
   \item{"none"}{BLOCK_NONE}
}}
}
\value{
A character string containing the rewritten text with corrected grammar, generated by the Google PaLM API
based on the provided query and parameters.
}
\description{
This function sends a query with grammatical issues to the Google PaLM 2 text model and generates corrected text as a response.
It allows customization of the generated text using various parameters.
}
\details{
This function interacts with the Google PaLM model by sending a query with grammatical issues using the specified parameters.
It allows you to customize the generated text by adjusting the `temperature`, `maxOutputTokens`, `topP`, `topK`, and safety settings.

If the function is successful, it returns a character string containing the rewritten text with corrected grammar.
If an error occurs during the API request, it will stop execution and provide an error message.

The `model.parameter` argument should be a character vector with the API key, model version, and model type provided by
Google. You can obtain this information by following the instructions provided by Google for using the PaLM API.

The safety settings control the content's safety level based on different harm categories. Harm thresholds are
specified as per Google's guidelines and can be customized to control the content generated.
}
\examples{
\dontrun{
# Connect to the model, replace API_KEY with your api key
palm.model = palm.connect("v1beta2",
                          "API_KEY",
                          FALSE)

prompt = "Yesterday, I will buy a book for my younger sister as his birthday gift.
          They were very happen when seeing this gift earlier today."
correct.text = palm.txt.fix.grammar(palm.model,
                                    prompt)
cat(correct.text)
}

}
\seealso{
\href{https://palmr.ly.gd.edu.kg/documentation/}{PaLMr - Documentation}

\href{https://ai.google.dev/api/rest/v1beta/SafetySetting}{Safety Setting - Google AI for Developers}

\href{https://ai.google.dev/api/rest/v1beta/HarmCategory}{HarmCategory - Google AI for Developers}
}
