% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palm.txt.explain.code.R
\name{palm.txt.explain.code}
\alias{palm.txt.explain.code}
\title{Explain code based on a query using the Google PaLM 2 text model}
\usage{
palm.txt.explain.code(
  model.parameter,
  prompt,
  language = "R",
  temperature = 0.7,
  maxOutputTokens = 1024,
  topP = 0.95,
  topK = 40,
  htUnspecified = "meda",
  htDerogatory = "meda",
  htToxicity = "meda",
  htViolence = "meda",
  htSexual = "meda",
  htMedical = "meda",
  htDangerous = "meda"
)
}
\arguments{
\item{model.parameter}{A character vector containing the API key, model version, and proxy status. Model version and type
are specified by Google. See function \code{\link{palm.connect}} for detail.}

\item{prompt}{A character string representing the code snippet for explanation. The length of the code snippet should be between
1 and 8196 characters, inclusive.}

\item{language}{A character string specifying the programming language used in the code (default: "R").}

\item{temperature}{A numeric value between 0.0 and 1.0, inclusive (default: 0.7). Controls the randomness of the generated explanation.
A higher value (e.g., 0.9) results in more creative responses, while a lower value (e.g., 0.3) produces more straightforward explanations.}

\item{maxOutputTokens}{An integer value (default: 1024). Specifies the maximum number of tokens to include
in the generated explanation.}

\item{topP}{A numeric value (default: 0.95). Defines the maximum cumulative probability of tokens considered
when sampling. It controls the diversity of the explanation generated.}

\item{topK}{An integer value (default: 40). Sets the maximum number of tokens to consider when sampling.}

\item{htUnspecified}{Safety setting threshold for unspecified harm. The default threshold is "meda". Valid options are as follows.

\describe{
   \item{"unsp"}{HARM_BLOCK_THRESHOLD_UNSPECIFIED}
   \item{"lowa"}{BLOCK_LOW_AND_ABOVE}
   \item{"meda"}{BLOCK_MEDIUM_AND_ABOVE}
   \item{"high"}{BLOCK_ONLY_HIGH}
   \item{"none"}{BLOCK_NONE}
}}

\item{htDerogatory}{Safety setting threshold for derogatory harm. The default threshold is "meda". Valid options are as follows.

\describe{
   \item{"unsp"}{HARM_BLOCK_THRESHOLD_UNSPECIFIED}
   \item{"lowa"}{BLOCK_LOW_AND_ABOVE}
   \item{"meda"}{BLOCK_MEDIUM_AND_ABOVE}
   \item{"high"}{BLOCK_ONLY_HIGH}
   \item{"none"}{BLOCK_NONE}
}}

\item{htToxicity}{Safety setting threshold for toxicity harm. The default threshold is "meda". Valid options are as follows.

\describe{
   \item{"unsp"}{HARM_BLOCK_THRESHOLD_UNSPECIFIED}
   \item{"lowa"}{BLOCK_LOW_AND_ABOVE}
   \item{"meda"}{BLOCK_MEDIUM_AND_ABOVE}
   \item{"high"}{BLOCK_ONLY_HIGH}
   \item{"none"}{BLOCK_NONE}
}}

\item{htViolence}{Safety setting threshold for violence harm. The default threshold is "meda". Valid options are as follows.

\describe{
   \item{"unsp"}{HARM_BLOCK_THRESHOLD_UNSPECIFIED}
   \item{"lowa"}{BLOCK_LOW_AND_ABOVE}
   \item{"meda"}{BLOCK_MEDIUM_AND_ABOVE}
   \item{"high"}{BLOCK_ONLY_HIGH}
   \item{"none"}{BLOCK_NONE}
}}

\item{htSexual}{Safety setting threshold for sexual harm. The default threshold is "meda". Valid options are as follows.

\describe{
   \item{"unsp"}{HARM_BLOCK_THRESHOLD_UNSPECIFIED}
   \item{"lowa"}{BLOCK_LOW_AND_ABOVE}
   \item{"meda"}{BLOCK_MEDIUM_AND_ABOVE}
   \item{"high"}{BLOCK_ONLY_HIGH}
   \item{"none"}{BLOCK_NONE}
}}

\item{htMedical}{Safety setting threshold for medical harm. The default threshold is "meda". Valid options are as follows.

\describe{
   \item{"unsp"}{HARM_BLOCK_THRESHOLD_UNSPECIFIED}
   \item{"lowa"}{BLOCK_LOW_AND_ABOVE}
   \item{"meda"}{BLOCK_MEDIUM_AND_ABOVE}
   \item{"high"}{BLOCK_ONLY_HIGH}
   \item{"none"}{BLOCK_NONE}
}}

\item{htDangerous}{Safety setting threshold for dangerous harm. The default threshold is "meda". Valid options are as follows.

\describe{
   \item{"unsp"}{HARM_BLOCK_THRESHOLD_UNSPECIFIED}
   \item{"lowa"}{BLOCK_LOW_AND_ABOVE}
   \item{"meda"}{BLOCK_MEDIUM_AND_ABOVE}
   \item{"high"}{BLOCK_ONLY_HIGH}
   \item{"none"}{BLOCK_NONE}
}}
}
\value{
A character string containing the detailed explanation of the provided code snippet based on the query and parameters.
}
\description{
This function sends a query with a code snippet to the Google PaLM 2 text model and generates a detailed explanation of the code. It supports
various programming languages and allows you to customize the explanation.
}
\details{
This function interacts with the Google PaLM model by sending a code query to explain code. It allows you to customize the generated
code explanations by specifying the programming language, and additional parameters like temperature, token limits, and safety settings.

If the function is successful, it returns a detailed explanation of the provided code as a character string. If an error occurs during the
API request, it will stop execution and provide an error message.

The `model.parameter` argument should be a character vector with the API key, model version, and model type provided by
Google. You can obtain this information by following the instructions provided by Google for using the PaLM API.

The safety settings control the content's safety level based on different harm categories. Harm thresholds are
specified as per Google's guidelines and can be customized to control the content generated.
}
\examples{
\dontrun{
# Connect to the model, replace API_KEY with your api key
palm.model = palm.connect("v1beta2",
                          "API_KEY",
                          FALSE)

prompt = "foo <- function(n) {
            if (n <= 0) {
              return(0)
            } else if (n == 1) {
              return(1)
            } else {
              return(foo(n - 1) + foo(n - 2))
            }
          }"
code.explanation = palm.txt.explain.code(palm.model,
                                         prompt)
cat(code.explanation)
}

}
\seealso{
\href{https://palmr.ly.gd.edu.kg/documentation/}{PaLMr - Documentation}

\href{https://ai.google.dev/api/rest/v1beta/SafetySetting}{Safety Setting - Google AI for Developers}

\href{https://ai.google.dev/api/rest/v1beta/HarmCategory}{HarmCategory - Google AI for Developers}
}
