% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LiveStock.R
\docType{data}
\name{LiveStock}
\alias{LiveStock}
\title{LiveStock data from Pakistan Social and Living Standard Measures 2015}
\format{A \code{data.table} and  \code{data.frame} with 3771 observations of  116 variables.
\describe{
       \item{\code{hhcode}}{Household 10 digits  code.}
       \item{\code{Province}}{Province of Pakistan}
       \item{\code{Region}}{Region of Pakistan (Rural/Urban)}
       \item{\code{PSU}}{primary sampling unit 8 digits code}
       \item{\code{S7bc1.151}}{Cattle's present value (Rs.)}
       \item{\code{S7bc2.151}}{Cattle's last year value (Rs.)}
       \item{\code{S7bc3.151}}{Cattle's value sold in last year (Rs.)}
       \item{\code{S7bc4.151}}{Cattle's value received as gift/inheritance (Rs.)}
       \item{\code{S7bc5.151}}{Cattle's paiment, purchased in last year (Rs.)}
       \item{\code{S7bc6.151}}{Given away/lost cattle's value (Rs.)}
       \item{\code{S7bc1.152}}{Buffalo's present value (Rs.)}
       \item{\code{S7bc2.152}}{Buffalo's last year value (Rs.)}
       \item{\code{S7bc3.152}}{Buffalo's value sold in last year (Rs.)}
       \item{\code{S7bc4.152}}{Buffalo's value received as gift/inheritance (Rs.)}
       \item{\code{S7bc5.152}}{Buffalo's paiment, purchased in last year (Rs.)}
       \item{\code{S7bc6.152}}{Given away/lost Buffalo's value (Rs.)}
       \item{\code{S7bc1.153}}{Camel's present value (Rs.)}
       \item{\code{S7bc2.153}}{Camel's last year value (Rs.)}
       \item{\code{S7bc3.153}}{Camel's value sold in last year (Rs.)}
       \item{\code{S7bc4.153}}{Camel's value received as gift/inheritance (Rs.)}
       \item{\code{S7bc5.153}}{Camel's paiment, purchased in last year (Rs.)}
       \item{\code{S7bc6.153}}{Given away/lost camel's value (Rs.)}
       \item{\code{S7bc1.154}}{Sheep's present value (Rs.)}
       \item{\code{S7bc2.154}}{Sheep's last year value (Rs.)}
       \item{\code{S7bc3.154}}{Sheep's value sold in last year (Rs.)}
       \item{\code{S7bc4.154}}{Sheep's value received as gift/inheritance (Rs.)}
       \item{\code{S7bc5.154}}{Sheep's paiment, purchased in last year (Rs.)}
       \item{\code{S7bc6.154}}{Given away/lost sheep's value (Rs.)}
       \item{\code{S7bc1.155}}{Goat's present value (Rs.)}
       \item{\code{S7bc2.155}}{Goat's last year value (Rs.)}
       \item{\code{S7bc3.155}}{Goat's value sold in last year (Rs.)}
       \item{\code{S7bc4.155}}{Goat's value received as gift/inheritance (Rs.)}
       \item{\code{S7bc5.155}}{Goat's paiment, purchased in last year (Rs.)}
       \item{\code{S7bc6.155}}{Given away/lost goat's value (Rs.)}
       \item{\code{S7bc1.156}}{Horse's present value (Rs.)}
       \item{\code{S7bc2.156}}{Horse's last year value (Rs.)}
       \item{\code{S7bc3.156}}{Horse's value sold in last year (Rs.)}
       \item{\code{S7bc4.156}}{Horse's value received as gift/inheritance (Rs.)}
       \item{\code{S7bc5.156}}{Horse's paiment, purchased in last year (Rs.)}
       \item{\code{S7bc6.156}}{Given away/lost horse's value (Rs.)}
       \item{\code{S7bc1.157}}{Asse's present value (Rs.)}
       \item{\code{S7bc2.157}}{Asse's last year value (Rs.)}
       \item{\code{S7bc3.157}}{Asse's value sold in last year (Rs.)}
       \item{\code{S7bc4.157}}{Asse's value received as gift/inheritance (Rs.)}
       \item{\code{S7bc5.157}}{Asse's paiment, purchased in last year (Rs.)}
       \item{\code{S7bc6.157}}{Given away/lost asse's value (Rs.)}
       \item{\code{S7bc1.158}}{Mule's present value (Rs.)}
       \item{\code{S7bc2.158}}{Mule's last year value (Rs.)}
       \item{\code{S7bc3.158}}{Mule's value sold in last year (Rs.)}
       \item{\code{S7bc4.158}}{Mule's value received as gift/inheritance (Rs.)}
       \item{\code{S7bc5.158}}{Mule's paiment, purchased in last year (Rs.)}
       \item{\code{S7bc6.158}}{Given away/lost mule's value (Rs.)}
       \item{\code{S7bc1.159}}{Poultry's present value (Rs.)}
       \item{\code{S7bc2.159}}{Poultry's last year value (Rs.)}
       \item{\code{S7bc3.159}}{Poultry's value sold in last year (Rs.)}
       \item{\code{S7bc4.159}}{Poultry's value received as gift/inheritance (Rs.)}
       \item{\code{S7bc5.159}}{Poultry's paiment, purchased in last year (Rs.)}
       \item{\code{S7bc6.159}}{Given away/lost poultry's value (Rs.)}
       \item{\code{S7bc1.160}}{Other animal's present value (Rs.)}
       \item{\code{S7bc2.160}}{Other animal's last year value (Rs.)}
       \item{\code{S7bc3.160}}{Other animal's value sold in last year (Rs.)}
       \item{\code{S7bc4.160}}{Other animal's value received as gift/inheritance (Rs.)}
       \item{\code{S7bc5.160}}{Other animal's paiment, purchased in last year (Rs.)}
       \item{\code{S7bc6.160}}{Given away/lost other animal's value (Rs.)}
       \item{\code{S7bc1.165}}{Total animal's present value (Rs.)}
       \item{\code{S7bc2.165}}{Total animal's last year value (Rs.)}
       \item{\code{S7bc3.165}}{Total animal's value sold in last year (Rs.)}
       \item{\code{S7bc4.165}}{Total animal's value received as gift/inheritance (Rs.)}
       \item{\code{S7bc5.165}}{Total animal's paiment, purchased in last year (Rs.)}
       \item{\code{S7bc6.165}}{Total given out/lost animal's value (Rs.)}
       \item{\code{S7bc1.166}}{Monthly value of eggs produced (Rs.)}
       \item{\code{S7bc2.166}}{No. of months eggs produced (Rs.)}
       \item{\code{S7bc3.166}}{Total value of eggs produced (Rs.)}
       \item{\code{S7bc1.167}}{Monthly value of milk produced (Rs.)}
       \item{\code{S7bc2.167}}{No. of months milk produced (Rs.)}
       \item{\code{S7bc3.167}}{Total value of milk produced (Rs.)}
       \item{\code{S7bc1.168}}{Monthly value of milk products produced (Rs.)}
       \item{\code{S7bc2.168}}{No. of months milk products produced (Rs.)}
       \item{\code{S7bc3.168}}{Total value of milk products produced (Rs.)}
       \item{\code{S7bc3.169}}{Total value of honey produced (Rs.)}
       \item{\code{S7bc3.170}}{Total value of forset products produced (Rs.)}
       \item{\code{S7bc3.171}}{Total value of fish catches (Rs.)}
       \item{\code{S7bc3.172}}{Total value of dung cakes produced (Rs.)}
       \item{\code{S7bc3.173}}{Total value of wool produced (Rs.)}
       \item{\code{S7bc3.174}}{Total value of other items produced (Rs.)}
       \item{\code{S7bc3.175}}{Total value of all other items produced (Rs.)}
       \item{\code{S7bc3.180}}{Total value of all items produced (Rs.)}
       \item{\code{S7bc1.181}}{Fodder green purchased (Rs.)}
       \item{\code{S7bc2.181}}{Fodder green own produced and consumed (Rs.)}
       \item{\code{S7bc1.182}}{Fodder dry purchased (Rs.)}
       \item{\code{S7bc2.182}}{Fodder dry own produced and consumed (Rs.)}
       \item{\code{S7bc1.183}}{Grazing purchased (Rs.)}
       \item{\code{S7bc2.183}}{Grazing own produced and consumed (Rs.)}
       \item{\code{S7bc1.184}}{Oil cakes/seed purchased (Rs.)}
       \item{\code{S7bc2.184}}{Oil cakes/seed own produced and consumed (Rs.)}
       \item{\code{S7bc1.185}}{Poultry feed purchased (Rs.)}
       \item{\code{S7bc2.185}}{Poultry feed own produced and consumed (Rs.)}
       \item{\code{S7bc1.186}}{fishing purchased (Rs.)}
       \item{\code{S7bc2.186}}{fishing own produced and consumed (Rs.)}
       \item{\code{S7bc1.187}}{Medicines purchased (Rs.)}
       \item{\code{S7bc2.187}}{Medicines own produced and consumed (Rs.)}
       \item{\code{S7bc1.188}}{Veterinary charges (Rs.)}
       \item{\code{S7bc2.188}}{Veterinary own services charges (Rs.)}
       \item{\code{S7bc1.189}}{Labour charges (Rs.)}
       \item{\code{S7bc2.189}}{Own labour services charges (Rs.)}
       \item{\code{S7bc1.190}}{All other items purchased (Rs.)}
       \item{\code{S7bc2.190}}{All other items own produced and consumed (Rs.)}
       \item{\code{S7bc1.195}}{Total items purchased (Rs.)}
       \item{\code{S7bc2.195}}{Total items own produced and consumed (Rs.)}
       \item{\code{S7bc1.196}}{Rent out agricultural equipment status}
       \item{\code{S7bc1.197}}{Rent received in an year (Rs.)}
       \item{\code{S7bc1.198}}{Sold agricultural equipment value (Rs.)}
       \item{\code{S7bc2.198}}{Value of agricultural equipment received as gift/inheritance (Rs.)}
       \item{\code{S7bc3.198}}{Paiment of purchased agricultural equipment (Rs.)}
       \item{\code{S7bc4.198}}{Value of agricultural equipment given away/lost (Rs.)}
       }}
\usage{
data(LiveStock)
}
\description{
\code{LiveStock} data from Pakistan Social and Living Standard Measures 2015.
}
\examples{
 # library(PSLM2015)
 # data("LiveStock")
 # library(dplyr)
 # TotalValue <- LiveStock \%>\%
 #   group_by(Province, Region) \%>\%
 #   summarise(TotalValue = sum(S7bc3.165, na.rm = TRUE))
 # 
 # library(ggplot2)
 # ggplot(data = TotalValue, mapping = aes(x = Province, y = TotalValue)) +
 #  geom_col() +
 #  labs(y = "Total Value of Owned Animals") +
 #   facet_grid(. ~ Region)
}
\references{
\enumerate{
\item Pakistan Bureau of Statistics, Micro data (\url{http://www.pbs.gov.pk/content/microdata}).
 }
}
\seealso{
\code{\link{Employment}}
 , \code{\link{Education}}
 , \code{\link{Expenditure}}
 , \code{\link{HHRoster}}
 , \code{\link{Housing}}
 , \code{\link{ICT}}
 , \code{\link{Agriculture}}
}
\author{
\enumerate{
\item Muhammad Yaseen (\email{myaseen208@gmail.com})
 \item Muhammad Arfan Dilber (\email{pbsfsd041@gmail.com})
 }
}
\keyword{datasets}
