% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lms4.pvalue.R
\name{Lms4.pvalue}
\alias{Lms4.pvalue}
\title{Logarithmic minimum test for independence in four-way contingency table}
\usage{
Lms4.pvalue(stat, nr, nc, nt, nu, n, B = 10000)
}
\arguments{
\item{stat}{a Logarithmic minimum statistic value}

\item{nr}{a number of rows}

\item{nc}{a number of columns}

\item{nt}{a number of tubes}

\item{nu}{a number of}

\item{n}{a sample size}

\item{B}{an integer specifying the number of replicates used in the Monte Carlo test (optional)}
}
\value{
The function returns the p-value of the logarithmic minimum test.
}
\description{
Calculates the p-value of the Logarithmic minimum test for independence in four-way contingency table
}
\details{
The Critical value of the modular test for independence in r x c x t x u contingency table,
}
\examples{
data = GenTab4(array(1/16, dim = c(2, 2, 2, 2)), 160)
Lms4.pvalue(Lms4.stat(data), 2, 2, 2, 2, 160, B=1e3)
Lms4.pvalue(Lms4.stat(table6), 2, 2, 2, 2, 160, B = 1e2)

}
\references{
Extension of the information contained in {Sulewski, P. (2021). \emph{Logarithmic Minimum Test for Independence in Three Way Con-tingency Table of Small Sizes,} Journal of Statistical Computation and Simulation 91(13), 2780-2799}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
