% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lms2.stat.R
\name{Lms2.stat}
\alias{Lms2.stat}
\title{Logarithmic Minimum Test for Independence in Two-Way Contingency Table}
\usage{
Lms2.stat(nij)
}
\arguments{
\item{nij}{a numeric matrix with non-negative values of the two-way contingency table cells}
}
\value{
The function returns the value of the logarithmic minimum test statistic
}
\description{
Calculates the logarithmic minimum statistics (see Sulewski P. (2019)).
}
\details{
The statistic of the logarithmic minimum test for independence in r x c contingency table,
see formula (4) and example 3 in the article.
}
\examples{
Lms2.stat(table1)
Lms2.stat(table2)

}
\references{
{Sulewski, P. (2019). \emph{The LMS for Testing Independence in Two-way Contingency Tables.} Biometrical Letters 56(1), 17-43}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
