% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cormat.R
\name{cor_matrix}
\alias{cor_matrix}
\title{Generate Correlation Matrix.}
\usage{
cor_matrix(num_samples = 100, num_vars = 5, dists = dists)
}
\arguments{
\item{num_samples}{The number of samples to generate.}

\item{num_vars}{The number of distributions to sample.}

\item{dists}{A list describing each distribution.}
}
\value{
The function returns the correlation matrix for the distributions.
}
\description{
Generate Correlation Matrix.
}
\examples{
# List of probability distributions
dists <- list(
  normal = function(n) rnorm(n, mean = 0, sd = 1),
  uniform = function(n) runif(n, min = 0, max = 1),
  exponential = function(n) rexp(n, rate = 1),
  poisson = function(n) rpois(n, lambda = 1),
  binomial = function(n) rbinom(n, size = 10, prob = 0.5)
)

# Generate correlation matrix
cor_matrix <- cor_matrix(num_samples = 100, num_vars = 5, dists = dists)

# Print correlation matrix
print(cor_matrix)
}
