% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPass.R
\name{PPass}
\alias{PPass}
\alias{PPass.default}
\alias{PPass.Rm}
\title{Person Assessment function}
\usage{
PPass(...)

\method{PPass}{default}(
  respdf,
  items = "all",
  mod = c("1PL", "2PL", "3PL", "4PL", "PCM", "GPCM", "MIXED"),
  fitindices = c("lz", "lzstar", "infit", "outfit"),
  ...
)

\method{PPass}{Rm}(RMobj, fitindices = c("lz", "lzstar", "infit", "outfit"), ...)
}
\arguments{
\item{respdf}{A data.frame which contains the items, and perhaps other informations. Each row is a person related resonse patter. Each column denotes a variable.}

\item{items}{A numeric (integer) vector which indicates the positions of the items in the data.frame (\code{respdf}). If \code{items} = 'all', \bold{all columns} are treated as items.}

\item{mod}{Choose your data generating model. This argument switches between the three person parameter estimating functions \code{PP_4pl}, \code{PP_gpcm} and \code{PPall}.}

\item{fitindices}{A character vector which denotes the fit indices to compute.}

\item{RMobj}{A fitted Rasch Model (\code{RM()}) object which stems from the \code{eRm} package.}

\item{\ldots}{Submit arguments to the underlying functions: \code{PP_4pl}, \code{PP_gpcm} and \code{PPall} (see documentation files) for person parameter estimation.}
}
\value{
The original data.frame and

\itemize{

\item The Person Parameter estimates incl. Standard Errors (2 columns)

\item Person Fit Indices you chose (1 or more)

}
}
\description{
Estimate Person Paramters and calculate Person Fit in one step to gain resonse pattern assessment. Submit a data.frame which contains item responses, or an fitted model (Rasch Model and Partial Credit Model are supported) of the \code{eRm} package.
}
\details{
PPass fuses Person Parameter estimation and Person Fit computation into a single function.
}
\examples{

library(eRm)
### real data ##########

data(pp_amt)

d <- pp_amt$daten_amt

rd_res <- PPass(respdf = d, 
                items = 8:ncol(d),
                mod="1PL",
                thres = pp_amt$betas[,2], 
                fitindices = "lz")

head(rd_res)


## ========== RM - eRm 
my_data <- eRm::sim.rasch(200, 12)
my_rm <- eRm::RM(my_data)

res_pp1 <- PPass(my_rm)


## ========== PCM - eRm

set.seed(2751)

THRES  <- matrix(c(-2,-1.23,1.11,3.48,1
                   ,2,-1,-0.2,0.5,1.3,-0.8,1.5),nrow=2)
THRES <- rbind(THRES,c(-0.2,NA,NA,NA,NA,NA))

sl          <- rep(1,6)
THRESx      <- rbind(0,THRES)
THETA       <- rnorm(200)
simdat_gpcm <- sim_gpcm(thres = THRESx,alpha = sl,theta = THETA)

my_pcm <- eRm::PCM(simdat_gpcm)

res_pp2 <- PPass(my_pcm)

## ==========  1PL model

set.seed(1337)

# intercepts
diffpar <- seq(-3,3,length=15)
# slope parameters
sl     <- round(runif(15,0.5,1.5),2)
la     <- round(runif(15,0,0.25),2)
ua     <- round(runif(15,0.8,1),2)

# response matrix
awm <- matrix(sample(0:1,100*15,replace=TRUE),ncol=15)
awm <- as.data.frame(awm)
# estimate person parameter

# estimate person parameter and person fit
out <- PPass(respdf = awm,thres = diffpar, items="all",
             mod=c("1PL"), fitindices= c("lz","lzstar","infit","outfit"))

# show first rows
head(out)
}
\seealso{
\link{PP_4pl}, \link{PP_gpcm}, \link{PPall}, \link{Pfit}
}
\author{
Manuel Reif, Jan Steinfeld
}
