% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLreg.R
\name{CI.lambda}
\alias{CI.lambda}
\title{Confidence Interval for the Skewness Parameter}
\usage{
CI.lambda(object, conf.coef = 0.95, lower = NULL, upper = NULL)
}
\arguments{
\item{object}{fitted model object of class "\code{PLreg}".}

\item{conf.coef}{confidence level of the confidence interval. Default is 0.95.}

\item{lower}{a numeric value representing the lower limit of the interval for
the skewness parameter. If \code{lower = NULL}, the lower limit is selected
by the function.}

\item{upper}{a numeric value representing the upper limit of the interval for
the skewness parameter. If \code{upper = NULL}, the upper limit is selected
by the function.}
}
\value{
The function returns a plot of the profile penalized likelihood ratio
statistics for lambda with a horizontal dashed line, indicating the confidence
interval for lambda. It also shows the confidence interval obtained.
}
\description{
The \code{CI.lambda} function provides a plot of the profile (penalized)
likelihood ratio statistics for lambda, useful to obtain confidence
intervals for the skewness parameter (see Queiroz and Ferrari (2022)).
}
\examples{
data("PeruVotes")

fitPL <- PLreg(votes ~ HDI | HDI, 
  data = PeruVotes, 
  family = "TF", zeta = 5)
\donttest{
CI.lambda(fitPL)}
}
