% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{is.top_ordering}
\alias{is.top_ordering}
\title{Top-ordering datasets}
\usage{
is.top_ordering(data, ...)
}
\arguments{
\item{data}{An object containing the partial orderings whose consistency with a top-ordering dataset has to be tested. The following classes are admissible for \code{data}: numeric \code{matrix}, \code{data.frame}, \code{RandData} from the \code{rankdist} package and \code{rankings} from the \code{PlackettLuce} package.}

\item{...}{Further arguments passed to or from other methods (not used).}
}
\value{
Logical: \code{TRUE} if the \code{data} argument is consistent with a top-ordering dataset (with a possible warning message if the supplied data need a further treatment with the coercion function \code{\link{as.top_ordering}} before being processed with the core functions of \pkg{PLMIX}) and \code{FALSE} otherwise.
}
\description{
Check the consistency of partial ordering data with a top-ordering dataset.
}
\details{
The argument \code{data} requires the partial sequences expressed in ordering format. When the value of \code{is.top-ordering} is \code{FALSE}, the membership function returns also a message with the conditions that are not met for the \code{data} to be a top-ordering dataset. \code{NA}'s in the input \code{data} are tacitly converted into zero entries.
}
\examples{

## A toy example of data matrix not satisfying the conditions to be a top-ordering dataset
toy_data=rbind(1:5,
c(0,4,3,2,1),
c(4,3.4,2,1,5),
c(2,3,0,0,NA),
c(4,4,3,2,5),
c(3,5,4,2,6),
c(2,-3,1,4,5),
c(2,0,1,4,5),
c(2,3,1,1,1),
c(2,3,0,4,0))

is.top_ordering(data=toy_data)

## A dataset from the StatRank package satisfying the conditions to be a top-ordering dataset
library(StatRank)
data(Data.Election9)
is.top_ordering(data=Data.Election9)

}
\references{
Turner, H., Kormidis, I. and Firth, D. (2018). PlackettLuce: Plackett-Luce Models for Rankings. R package version 0.2-3. \url{https://CRAN.R-project.org/package=PlackettLuce}

Qian, Z. (2018). rankdist: Distance Based Ranking Models. R package version 1.1.3. \url{https://CRAN.R-project.org/package=rankdist}
}
\author{
Cristina Mollica and Luca Tardella
}
