% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simultest.cauchy.R
\name{simultest.cauchy}
\alias{simultest.cauchy}
\title{Two-sample simultaneous test using Cauchy combination}
\usage{
simultest.cauchy(dataX,dataY)
}
\arguments{
\item{dataX}{an \eqn{n_1} by \eqn{p} data matrix}

\item{dataY}{an \eqn{n_2} by \eqn{p} data matrix}
}
\value{
\code{stat} the value of test statistic

\code{pval} the p-value for the test.
}
\description{
This function implements the two-sample simultaneous test on high-dimensional
mean vectors and covariance matrices using Cauchy combination.
Suppose \eqn{\{\mathbf{X}_1, \ldots, \mathbf{X}_{n_1}\}} are i.i.d.
copies of \eqn{\mathbf{X}}, and \eqn{\{\mathbf{Y}_1, \ldots, \mathbf{Y}_{n_2}\}}
are i.i.d. copies of \eqn{\mathbf{Y}}.
Let \eqn{p_{CQ}} and \eqn{p_{LC}} denote the \eqn{p}-values associated with
the \eqn{l_2}-norm-based mean test proposed in Chen and Qin (2010)
(see \code{\link{meantest.cq}} for details)
and the \eqn{l_2}-norm-based covariance test proposed in Li and Chen (2012)
(see \code{\link{covtest.lc}} for details),
respectively. The simultaneous test statistic via Cauchy combination is defined as
\deqn{C_{n_1, n_2} = \frac{1}{2}\tan((0.5-p_{CQ})\pi) + \frac{1}{2}\tan((0.5-p_{LC})\pi).}
It has been proved that with some regularity conditions, under the null hypothesis
\eqn{H_0: \boldsymbol{\mu}_1 = \boldsymbol{\mu}_2 \ \text{ and }
\ \mathbf{\Sigma}_1 = \mathbf{\Sigma}_2},
the two tests are asymptotically independent as \eqn{n_1, n_2, p\rightarrow \infty},
and therefore \eqn{C_{n_1,n_2}} asymptotically converges in distribution to
a standard Cauchy distribution.
The asymptotic \eqn{p}-value is obtained by
\deqn{p\text{-value} = 1-F_{Cauchy}(C_{n_1,n_2}),}
where \eqn{F_{Cauchy}(\cdot)} is the cdf of the standard Cauchy distribution.
}
\examples{
n1 = 100; n2 = 100; pp = 500
set.seed(1)
X = matrix(rnorm(n1*pp), nrow=n1, ncol=pp)
Y = matrix(rnorm(n2*pp), nrow=n2, ncol=pp)
simultest.cauchy(X,Y)
}
\references{
Chen, S. X. and Qin, Y. L. (2010). A two-sample test for high-dimensional data
with applications to gene-set testing.
\emph{Annals of Statistics}, 38(2):808–835.

Li, J. and Chen, S. X. (2012). Two sample tests for high-dimensional
covariance matrices. \emph{The Annals of Statistics}, 40(2):908–940.

Yu, X., Li, D., Xue, L., and Li, R. (2022). Power-enhanced simultaneous test
of high-dimensional mean vectors and covariance matrices with application
to gene-set testing. \emph{Journal of the American Statistical Association},
(in press):1–14.
}
