% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Parameter_estimation_and_hypothesis_testing.R
\name{MLEp.bsci}
\alias{MLEp.bsci}
\title{Bootstrap confidence interval for the MLE of \eqn{\psi}}
\usage{
MLEp.bsci(x, level = 0.95, rounds = 1000, frac = 0.8)
}
\arguments{
\item{x}{A data vector.}

\item{level}{Level of confidence interval as number between 0 and 1.}

\item{rounds}{Number of bootstrap rounds. Default is 1000.}

\item{frac}{Percentage of data \code{x} used for each bootstrap round. 0.8 by default with accepted values between 0 and 1.}
}
\value{
The MLE of \eqn{\psi} as well as lower and upper bounds of the bootstrap
confidence interval.
}
\description{
A bootstrapped confidence interval for the Maximum Likelihood Estimate for
\eqn{\psi}.
}
\examples{
## Find a 95\% -confidence interval for the MLE of psi given a sample from the
## Poisson-Dirichlet distribution:
x<-rPD(n=10000, psi=100)
MLEp.bsci(x, 0.95, 100, 0.8)

}
