% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PDI.R
\name{PDI}
\alias{PDI}
\title{Percent Disease Index (PDI)}
\usage{
PDI(freq)
}
\arguments{
\item{freq}{A numeric vector of frequencies for each disease grade
(starting from grade 0).}
}
\value{
A numeric value representing Percent Disease Index (PDI).
}
\description{
Calculates Percent Disease Index (PDI) based on disease grades
and their corresponding frequencies.
}
\details{
PDI is calculated as:
\deqn{PDI = ( \sum (grade \times frequency) / (N \times max\_grade) ) \times 100}

where N is the total number of observations.
}
\examples{
{
freq <- c(10, 8, 6, 4, 2, 1)
PDI(freq)
}
}
