% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPCGroups.R
\name{getPCGroups}
\alias{getPCGroups}
\title{get protein complexes}
\usage{
getPCGroups(
  Groups,
  Organism = c("Human", "Mouse", "Rat", "Mammalia", "Bovine", "Dog", "Rabbit"),
  Type = c("GeneSymbol", "EntrezID", "UniprotID")
)
}
\arguments{
\item{Groups}{A data frame containing the protein complexes}

\item{Organism}{Organism. one of \code{Human}, \code{Mouse}, \code{Rat},
\code{Mammalia}, \code{Bovine}, \code{Dog}, or \code{Rabbit}.}

\item{Type}{The name type of the proteins in the protein complexes. One of
\code{GeneSymbol}, \code{EntrezID}, \code{UniprotID}}
}
\value{
A list of protein complexes
}
\description{
get protein complexes
}
\examples{
data(PCGroups)
PC.Human <- getPCGroups(Groups = PCGroups, Organism = "Human",
Type = "GeneSymbol")
}
