% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcl.R
\name{pcl}
\alias{pcl}
\title{Create a Proximal Causal Learning Object}
\usage{
pcl(outcome, trt, trt_pxy, out_pxy, covariates)
}
\arguments{
\item{outcome}{the outcome variable}

\item{trt}{the binary treatment variable}

\item{trt_pxy}{the treatment-inducing proxies}

\item{out_pxy}{the outcome-inducing proxies}

\item{covariates}{the observed confounders}
}
\value{
pcl returns an object of class "pcl", which wraps the treatment, outcome, treatment inducing confounding proxies, outcome inducing confounding proxies and other covariates
}
\description{
Create a proximal causal learning object, usually used as a variable in a model function. Argument matching
}
\examples{
n <- 100
outcome <- rnorm(n, 0, 1)
trt <- rbinom(n, 1, 0.5)
trt_pxy <- rnorm(n, 0, 1)
out_pxy <- rnorm(n, 0, 1)
covariates <- rnorm(n, 0, 1)
pcl_object <- pcl(outcome, trt, trt_pxy, out_pxy, covariates)
}
