% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{USRegionalMortality_df}
\alias{USRegionalMortality_df}
\title{US Region Mortality Rates by Cause (Cancer) and Gender}
\format{
A data frame with 400 observations and 6 variables:
\describe{
  \item{Region}{Administrative region under the Department of Health and Human Services (HHS) (factor with 10 levels).}
  \item{Status}{Rural or urban status (factor with 2 levels).}
  \item{Sex}{Gender of the individual (factor with 2 levels).}
  \item{Cause}{Cause of death (factor with 10 levels).}
  \item{Rate}{Mortality rate (numeric).}
  \item{SE}{Standard error of the mortality rate (numeric).}
}
}
\source{
Data taken from the lattice package.
This dataset is based on the study by the Rural Health Reform Policy Research Center: *Exploring Rural and Urban Mortality Differences*, August 2015, Bethesda, MD.
Available at \url{https://ruralhealth.und.edu/projects/health-reform-policy-research-center/rural-urban-mortality}.
}
\usage{
data(USRegionalMortality_df)
}
\description{
This dataset, USRegionalMortality_df, is a data frame containing mortality rates across all ages in the USA, recorded region-wise by cause of death, sex, and rural/urban status for the years 2011–2013.
It includes region-wide rates for each administrative region under the Department of Health and Human Services (HHS).
The dataset consists of 400 observations with 6 variables.
}
\details{
The dataset name has been kept as 'USRegionalMortality_df' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the OncoDataSets package and assists users in identifying
its specific characteristics. The suffix '_df' indicates that the dataset is a data frame. The original content has not been modified in any way.
}
