% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{ColonCancerChemo_df}
\alias{ColonCancerChemo_df}
\title{Chemotherapy for Stage B/C Colon Cancer}
\format{
A data frame with 1858 observations and 16 variables:
\describe{
  \item{id}{Patient identifier (numeric).}
  \item{study}{Study identifier (numeric).}
  \item{rx}{Treatment received: 1 = observation, 2 = levamisole, 3 = levamisole+5-FU (factor).}
  \item{sex}{Sex of the patient: 1 = male, 2 = female (numeric).}
  \item{age}{Age of the patient (numeric).}
  \item{obstruct}{Obstruction of the colon: 1 = yes, 0 = no (numeric).}
  \item{perfor}{Perforation of the colon: 1 = yes, 0 = no (numeric).}
  \item{adhere}{Adherence to nearby organs: 1 = yes, 0 = no (numeric).}
  \item{nodes}{Number of positive lymph nodes detected (numeric).}
  \item{status}{Survival status: 1 = alive, 2 = dead (numeric).}
  \item{differ}{Tumor differentiation: 1 = well, 2 = moderate, 3 = poor (numeric).}
  \item{extent}{Tumor extent: 1 = submucosa, 2 = muscle, 3 = serosa, 4 = contiguous structures (numeric).}
  \item{surg}{Surgical intervention: 0 = short, 1 = long (numeric).}
  \item{node4}{Presence of 4+ positive lymph nodes: 1 = yes, 0 = no (numeric).}
  \item{time}{Follow-up time in days (numeric).}
  \item{etype}{Event type: 1 = recurrence, 2 = death (numeric).}
}
}
\source{
Data taken from the survival package.
}
\usage{
data(ColonCancerChemo_df)
}
\description{
This dataset, ColonCancerChemo_df, is a data frame containing data from one of the first successful trials of adjuvant chemotherapy for stage B/C colon cancer. The dataset includes information from 1858 observations and 16 variables. Each patient has two records: one for recurrence and one for death.
}
\details{
The dataset name has been kept as 'ColonCancerChemo_df' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the OncoDataSets package and assists users in identifying
its specific characteristics. The suffix '_df' indicates that the dataset is a data frame. The original content has not been modified in any way.
}
