% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/os.clean.R
\name{os.clean}
\alias{os.clean}
\title{Clean data by eliminating predictors with many missing values}
\usage{
os.clean(x, missing = 0.1, lowest = 10)
}
\arguments{
\item{x}{A data matrix (raw: samples, col: predictors).}

\item{missing}{A ratio of missing values in each column allowed to be remained in the data.}

\item{lowest}{The lowest value to be leaved in the data.}
}
\value{
A data matrix (raw: samples, col: qualified predictors)
}
\description{
Clean data by eliminating predictors with many missing values
}
\examples{
data(Pinus)
train.raw <- Pinus$train
ncol(train.raw)

train <- os.clean(train.raw)
ncol(train)
}
\author{
Takahiko Koizumi
}
