#   Copyright 1993, 1994, 1995, 1996  Bank of Canada.
#   Copyright 1997 (June), Paul Gilbert.
#   Copyright 1997 (Aug.), Bank of Canada.
#   Copyright 1998, Bank of Canada.

#   The user of this software has the right to use, reproduce and distribute it.
#   Bank of Canada makes no warranties with respect to the software or its 
#   fitness for any particular purpose. The software is distributed by the Bank
#   of Canada and by Paul Gilbert solely on an "as is" basis. By using the  
#   software, user agrees to accept the entire risk of using this software.

################################################################################


#print.tframe.tstframe <- function(tf,digits=NULL, quote = T, prefix = "", ...) 
#invisible(print(unclass(tf), quote = quote))



#if( !exists("start.default"))  start.default <- start
#if( !exists("end.default")) end.default <- end
#if( !exists("frequency.default")) frequency.default <- frequency
if( !exists("time.default")) time.default <- time
if( !exists("is.inf")) is.inf <- is.na

"tsp<-" <-function(x,tf)
{if (is.null(tf)) 
   {attr(x, "tsp") <- tf
    if(inherits(x,"ts")) class(x) <- NULL
    return(x)
   }
 attr(x, "tsp") <-  tf  # previously c(tf[1:2]*tf[3], tf[3])
 class(x) <- "ts"
 x
}


#window.tstframe <-function(x, start=NULL, end=NULL, warn=T, eps=1e-9)
#  {window.ts(x, start=start, end=end)}

# Above should be possible but the R version of window.ts does not use optional
# values for start and end, but rather checks for missing arguments, so 
#  argument passing may cause problems. Also, warn is not supported and,
#  sometime in the past I found it necessary to add eps for date comparisons to
#  work properly in some situations.
# The following could be called window.tstframe, but then window.ts still 
#   causes problems.

window.ts <-function(x, start=NULL, end=NULL, warn=T, eps=1e-9)
    {f <- tsp(x)[3]
     if (is.null(start)) start <- tsp(x)[1]
     if (is.null(end))   end   <- tsp(x)[2]
     if (2 == length(start)) start <- start[1] + (start[2]-1)/f
     if (2 == length(end))    end  <-   end[1] + (  end[2]-1)/f
     if (start < tsp(x)[1])
        {start <- tsp(x)[1]
         if (warn) warning("Specified start earlier than start of data, start not changed.")
        }
     if (end > tsp(x)[2])
        {end <- tsp(x)[2]
         if (warn) warning("Specified end later than end of data, end not changed.")
        }
     leave <- (time(x) >= (start-eps)) & (time(x) <= (end+eps))
     if (is.matrix(x)) z <- unclass(x)[leave,,drop=F] #Rbug drop not supported for ts?
     else  z <- x[leave]
#     tsp(z) <- c(start, end, f)
#     class(z) <- class(x)
#     z
    ts(z, start=start, end=end, frequency=f)
    }

matplot <- function(x, y, type ="p", lty=1:3, xlab="x", ylab="y", 
              colors=c("black", "blue", "red", "green", "cyan"), ...) 
  {# lty only affects type="l"
   # if lty is not long enough it is repeated using colors so set lty=1 to
   #  make each plot a different colour.
   if (!is.matrix(y)) y <- matrix(y, length(y),1)
   # vector or column matrix is repeated for each column of y:
   if ((is.matrix(x)) && (ncol(x)==1)) x <- c(x) 
   if (!is.matrix(x)) x <- matrix(x, length(x), dim(y)[2])
   if (!all(dim(x) == dim(y)))
       stop("matplot array dimensions do not correspond.")
   colors <- c(t(matrix(colors, length(colors), length(lty))))
   if (length(colors) < ncol(y)) colors <- (rep(colors, ncol(y)))[seq(ncol(y))]
   if (length(lty) < ncol(y)) lty <- (rep(lty, ncol(y)))[seq(ncol(y))]
   for (i in 1:ncol(x)) 
     {if (i ==1) plot.default(x[,i],y[,i],xlim=range(x[!is.na(x)]), 
        ylim=range(y[!is.na(y)]),
        xlab=xlab, ylab=ylab, type=type, lty=lty[i], col=colors[i], ...)
      else lines(x[,i],y[,i], type=type, lty=lty[i], col=colors[i],  ...)
     }
   invisible()
  }



###############################################

#  ts specific methods   <<<<<<<<<<<<

################################################

tframe.tstframe <-function(x)
{tf <- tsp(x)
 class(tf) <- c("tstframe", "tframe")
 tf
}

start.tframe.tstframe <-function(tf) {c(floor(tf[1]), round(1 +(tf[1]%%1)*tf[3]))}

end.tframe.tstframe <-function(tf) {c(floor(tf[2]), round(1 + (tf[2]%%1)*tf[3]))}

periods.tframe.tstframe <-function(tf)  {1+round((tf[2]-tf[1])*tf[3])}

frequency.tframe.tstframe <-function(tf) {tf[3]}

time.tframe.tstframe <-function(tf) {tf[1] + (seq(periods(tf))-1)/tf[3]}

truncate.tframe.tstframe <-function(tf, start=NULL, end=NULL) 
    {if (!is.null(end))   tf[2] <- tf[1] + (end-1)/tf[3]
     if (!is.null(start)) tf[1] <- tf[1] + (start-1)/tf[3]
     tf
    }

expand.tframe.tstframe <-function(tf, add.start=0, add.end=0) 
    {tf[2] <- tf[2] + add.end/tf[3]
     tf[1] <- tf[1] - add.start/tf[3]
     tf
    }


earliest.start.index.tframe.tstframe <-function(x, ...) 
    {r <- 1
     fr <- frequency(x)
     args <- list(x, ...)
     for (i in seq(length(args)))
         {tf <- args[[i]]
          if (tf[3] != fr) stop("frequencies must be that same.")
          if (tf[1] < args[[r]][1]) r <- i
         }           
     r
    }

earliest.end.index.tframe.tstframe <-function(x, ...) 
    {r <- 1
     fr <- frequency(x)
     args <- list(x, ...)
     for (i in seq(length(args)))
         {tf <- args[[i]]
          if (tf[3] != fr) stop("frequencies must be that same.")
          if (tf[2] < args[[r]][2]) r <- i
         }           
     r
    }

latest.start.index.tframe.tstframe <-function(x, ...) 
    {r <- 1
     fr <- frequency(x)
     args <- list(x, ...)
     for (i in seq(length(args)))
         {tf <- args[[i]]
          if (tf[3] != fr) stop("frequencies must be that same.")
          if (tf[1] > args[[r]][1]) r <- i
         }           
     r
    }

latest.end.index.tframe.tstframe <-function(x, ...) 
    {r <- 1
     fr <- frequency(x)
     args <- list(x, ...)
     for (i in seq(length(args)))
         {tf <- args[[i]]
          if (tf[3] != fr) stop("frequencies must be that same.")
          if (tf[2] > args[[r]][2]) r <- i
         }           
     r
    }

window.tframed.tstframe <- function(tf, x, ...)
 {cl <- class(x)
  tframe(x) <- NULL
  class(x) <- "ts"
  attr(x, "tspar") <- unclass(tf)
  x <- window(x,...)
  tframe(x) <- tframe(x) # strange but the default action fixes the class
  class(x) <- cl
  x
 }

#   Copyright 1993, 1994, 1995, 1996  Bank of Canada.
#   Copyright 1997 (June), Paul Gilbert.
#   Copyright 1997 (Aug.), Bank of Canada.
#   Copyright 1998, Bank of Canada.

#   The user of this software has the right to use, reproduce and distribute it.
#   Bank of Canada makes no warranties with respect to the software or its 
#   fitness for any particular purpose. The software is distributed by the Bank
#   of Canada and by Paul Gilbert solely on an "as is" basis. By using the  
#   software, user agrees to accept the entire risk of using this software.

################################################################################


#  classes are set eg c("tstframe", "tframe") but this requires  checking as in start, end frequency, print.
#  It might?? work better in order ("tframe", "tstframe")

# tframe classes and methods       <<<<<<<<<<<<

###########################################################################

###############################################

#  generic methods  and defaults <<<<<<<<<<<<

################################################

# start, end, frequency, time and window
# are already generic functions in S with a default 
# method which works for vectors and matrices and data with a tsp attribute,
# but it is necessary to distinguish the tframe attribute and apply a method
# corresponding to the class of that attribute, rather than a method 
# corresponding to the class of the data object.

start <- function(x, ...)
 {if      (is.tframe(x))  start.tframe(x)
  else if (is.tframed(x)) start.tframe(tframe(x))
  else UseMethod("start")
 }

end <- function(x, ...)
 {if      (is.tframe(x))  end.tframe(x)
  else if (is.tframed(x)) end.tframe(tframe(x))
  else UseMethod("end")
 }

frequency <- function(x, ...)
 {if      (is.tframe(x))  frequency.tframe(x)
  else if (is.tframed(x)) frequency.tframe(tframe(x))
  else UseMethod("frequency")
 }

periods <- function(x, ...)
 {# the length in time of the sequence
  if      (is.tframe(x))  periods.tframe(x)
  else if (is.tframed(x)) periods.tframe(tframe(x))
  else UseMethod("periods")
 }

periods.default <- function(x)
  {if (is.array(x)) return(dim(x)[1])
   else return(length(x))
  }

time <- function(x, ...)
 {if      (is.tframe(x))  time.tframe(x)
  else if (is.tframed(x)) time.tframe(tframe(x))
  else UseMethod("time")
 }

print <- function(x, ...)
 {if      (is.tframed(x)) print.tframed(x, ...)
  else if (is.tframe(x))  print.tframe(x, ...)
  else UseMethod("print")
 }

plot <- function(y, ...)
 {if (is.tframed(y)) 
    {tf <-tframe(y)
     plot.tframed(tf, y, ...)
    }
  else UseMethod("plot")
 }

plot.tframed <- function(tf, y, ...) UseMethod("plot.tframed")

plot.tframed.default <- function(tf,y,...)
 {tline <- time(tf)
  matplot(tline, y, type="l", ...)
 }

# Note the following is different from print.tframe, which prints the tframe  
# info. This prints the data.

print.tframed <- function(x, ...)  UseMethod("print.tframed")

print.tframed.default <- function(x,...)
 {tframe(x) <- NULL
  print(x, ...)
 }


if( !exists("tsplot.default"))  
  {if(exists("tsplot")) tsplot.default <- tsplot 
   else tsplot.default <- function(x, ...) matplot(x=time(x),y=x,type="l", ...)
  }

tsplot <- function(y, ...)
 {if (is.tframed(y)) plot(y, ...)
  else UseMethod("tsplot")
 }




test.equal<- function(obj1, obj2, ...) UseMethod("test.equal")

test.equal.default <- function(obj1, obj2, ...) 
 {if (is.array(obj1)) test.equal.array(obj1, obj2, ...)
  else is.logical(all.equal(obj1, obj2, ...))
 }


test.equal.array <- function(d1, d2, fuzz = 1e-16)
  {if(any(dim(d1) != dim(d2))) r <- F
   else if ("character" == mode(d1)) r <- all(d1 == d2)
   else if ("numeric" == mode(d1))
           {r <- all(is.inf(d1) == is.inf(d2))
            if (r) 
              {nna <-!is.na(c(d1)) 
               r <- fuzz >= max(abs(c(d1)[nna] - c(d2)[nna]))
           }  }
   else stop(paste("matrix of mode ", mode(d1)," not testable."))
   if(is.na(r)) r <- F
   r
  }

test.equal.matrix <- test.equal.array


# previously below
#  if      (is.tframed(x)) 
#    {tf <- tframe(x)
#     window.tframed(tf, x, ...)
#    }

window <- function(x, ...)
 {if      (is.tframed(x)) return(window.tframed(tframe(x), x, ...) )
  else if (is.tframe(x))  UseMethod("window.tframe")
  else UseMethod("window")
 }

window.tframe  <- function(tf,...)UseMethod("window.tframe") 
window.tframed <- function(tf, x, ...) UseMethod("window.tframed")

window.tframed.rtstframe <- function(tf, x, ...)
 {cl <- class(x)
  tframe(x) <- NULL
  class(x) <- "rts"
  attr(x, "tspar") <- unclass(tf)
  x <- window(x,...)
  tframe(x) <- tframe(x) # strange but the default action fixes the class
  class(x) <- cl
  x
 }

window.tframed.ctstframe <- function(tf, x, ...)
 {cl <- class(x)
  tframe(x) <- NULL
  class(x) <- "cts"
  attr(x, "tspar") <- unclass(tf)
  x <- window(x,...)
  tframe(x) <- tframe(x) # strange but the default action fixes the class
  class(x) <- cl
  x
 }

window.tframed.itstframe <- function(tf, x, ...)
 {cl <- class(x)
  tframe(x) <- NULL
  class(x) <- "its"
  attr(x, "tspar") <- unclass(tf)
  x <- window(x,...)
  tframe(x) <- tframe(x) # strange but the default action fixes the class
  class(x) <- cl
  x
 }

window.tframed.default <- function(tf, x, ...)
 {cl <- class(x)
  tframe(x) <- NULL
  tsp(x) <-unclass(tf)
  x <- window(x,...)
  tframe(x) <- tframe(x) # strange but the default action fixes the class
  class(x) <- cl
  x
 }

lag <- function(x, ...)
 {if      (is.tframed(x)) return(lag.tframed(tframe(x), x, ...) )
  else if (is.tframe(x))  UseMethod("lag.tframe")
  else UseMethod("lag")
 }

lag.tframe  <- function(tf,...)UseMethod("lag.tframe") 
lag.tframed <- function(tf, x, ...) UseMethod("lag.tframed")

lag.tframed.default <- function(tf, x, ...)
 {cl <- class(x)
  tframe(x) <- NULL
  if (inherits(tf,"rts") | inherits(tf,"cts") | 
      inherits(tf,"its") | inherits(tf,"ts")) 
    {class(x) <- class(tf)
     attr(x, "tspar") <- tf
    }
  else  tsp(x) <-unclass(tf)
  x <- lag(x,...)
  tframe(x) <- tframe(x) # strange but the default action fixes the class
  class(x) <- cl
  x
 }


splice <- function(m1, m2, ...) UseMethod("splice")


splice.default <-function(mat1, mat2)
{# splice together 2 time series matrices. If data  is provided in both for
 #  a given period then mat1 takes priority.
 # The result starts at the earlier of mat1 and mat2 and ends at the later.
 # dimnames are taken from mat1.
 # The frequencies should be the same.
 if (is.null(mat1)) return(mat2)
 if (is.null(mat2)) return(mat1)
 freq <- frequency(mat1)
 if (freq != frequency(mat2)) stop("frequencies must be the same.")
 p <- dim(mat1)[2]
 if (p != dim(mat2)[2])   stop("number of series must be the same.")
 fr <- c(freq,1)
 st <- min(fr %*% start(mat1), fr %*% start(mat2))
 strt <- c(st %/% freq, st %% freq)
 en <- max(fr %*% end(mat1), fr%*% end(mat2))
 r1 <-r2 <-tframed(matrix(NA, 1+en-st, p), list(start=strt, frequency=freq))
 r1[c((fr %*% start(mat1))-st) + 1:dim(mat1)[1],] <- mat1
 r2[c((fr %*% start(mat2))-st) + 1:dim(mat2)[1],] <- mat2
 na <- is.na(r1)
 r1[na] <- r2[na] # put mat2 only in na locations of mat1
 dimnames(r1)<-list(round(time(r1),digits=3),dimnames(mat1)[[2]])
 r1 <- tframed(r1, list(start=earliest.start(mat1,mat2), 
                         end =latest.end(mat1,mat2), frequency=freq))
 r1
}


if( !exists("tsmatrix.default"))  
  {if(exists("tsmatrix")) tsmatrix.default <- tsmatrix 
   else tsmatrix.default <- function(x, ...) 
            {tbind(x, ..., pad.start=F, pad.end=F) }
  }

tsmatrix <- function(x, ...)
 {# the default tsmatrix messes up because it gets some time info. (from
  #  start or end) but not tsp info.
  if (is.tframed(x)) tbind(x, ..., pad.start=F, pad.end=F)
  else 
    {#warning("Using tsmatrix which should be defunct. Consider using tbind and tframe methods.")       
     tsmatrix.default(x,  ...)
    }
 }

tbind <- function(x, ..., pad.start=T, pad.end=T, warn=T) 
  {#bind data as in cbind or tsmatrix but align time and default action pads
   #series with NA to time union. 
   #If pad.start and/or pad.end is F and the intersection is empty then NULL
   # is returned and a warning is issued if warn=T.
   UseMethod("tbind")
  }
 

tbind.default <- function(x, ..., pad.start=T, pad.end=T, warn=T)
 {# this should work for old tsp vectors and matrices
  if (is.null(x)) stop("first argument cannot be NULL.")
  fr <- frequency(x)
  for (i in list(...)) {if (!is.null(i) && (fr != frequency(i)))
     stop("frequencies must be the same.")}
  fr <- c(fr,1)
  st <- fr %*% start(x) 
  for (i in list(...)) if (!is.null(i)) st <- min(st, fr %*% start(i) )
  en <- fr %*% end(x)
  for (i in list(...)) if (!is.null(i)) en <- max(en, fr %*% end(i) )
  r <- NULL
  nm <- attr(x, "names")
  attr(x, "names") <- NULL
  for (z in append(list(x),list(...))) if (!is.null(z))
    {if (is.matrix(z))
       {if (st == (fr %*% start(z))) before <- NULL
        else  before <-matrix(NA, (fr %*% start(z))-st, dim(z)[2])     
        if (en == (fr %*% end(z))) aft <- NULL
        else  aft    <-matrix(NA, en - (fr %*% end(z)), dim(z)[2])
        r <- cbind(r, rbind( before, z, aft) )
       }
     else 
       {if (st == (fr %*% start(z))) before <- NULL
        else  before <-rep(NA, (fr %*% start(z))-st)     
        if (en == (fr %*% end(z))) aft <- NULL
        else  aft <- rep(NA, en - (fr %*% end(z)))
        r <- cbind(r, c( before, z, aft) )
       }
    }
  if (!is.null(nm)) dimnames(r) <- list(nm,NULL)
  r <- tframed(r, list(start=c((st-1)%/%fr[1], 1+(st-1)%%fr[1]), frequency=fr[1]))
  if (!(pad.start & pad.end)) r <- trim.na(r, Start=!pad.start, End=!pad.end)
  if (is.null(r)) warning("intersection is NULL")
  r
 }


truncate <- function(x, start=NULL, end=NULL)
 {# similar to window but start and end specify periods relative to the 
  #   beginning (eg x[start:end] for a vector).
  #   NULL means no truncation.
  UseMethod("truncate")
 }

truncate.default <-function(x, start=NULL, end=NULL)
    {tf <- truncate.tframe(tframe(x), start, end)
     if (is.null(start)) start <- 1
     if (is.matrix(x)) 
        {if (is.null(end)) end <- dim(x)[1]
         z <- x[start:end,,drop=F]
        }
     else 
        {if (is.null(end)) end <- length(x)
         z <- x[start:end]
        }
     tframe(z) <- tf
     z
    }

expand <- function(x, add.start=0, add.end=0)
 {# expand (a tframe) by add.start periods on the beginning
  # and add.end periods on the end
  UseMethod("expand")
 }



earliest.start <-function(x, ...)
    start(append(list(x),list(...))[[earliest.start.index(x, ...)]])

earliest.start.index <-function(x, ...)
  {if (is.tframe(x)) UseMethod("earliest.start.index.tframe")
   else 
     {tf <- list(tframe(x))
      for (i in list(...)) tf <- append(tf, list(tframe(i)))
      r <- do.call("earliest.start.index.tframe", tf)
     }
   r
  }

earliest.end <-function(x, ...)
    end(append(list(x),list(...))[[earliest.end.index(x, ...)]])

earliest.end.index <-function(x, ...)
  {if (is.tframe(x)) UseMethod("earliest.end.index.tframe")
   else 
     {tf <- list(tframe(x))
      for (i in list(...)) tf <- append(tf, list(tframe(i)))
      r <- do.call("earliest.end.index.tframe", tf)
     }
   r
  }

latest.start <-function(x, ...)
    start(append(list(x),list(...))[[latest.start.index(x, ...)]])

latest.start.index <-function(x, ...)
  {if (is.tframe(x)) UseMethod("latest.start.index.tframe")
   else 
     {tf <- list(tframe(x))
      for (i in list(...)) tf <- append(tf, list(tframe(i)))
      r <- do.call("latest.start.index.tframe", tf)
     }
   r
  }

latest.end <-function(x, ...)
    end(append(list(x),list(...))[[latest.end.index(x, ...)]])

latest.end.index <-function(x, ...)
  {if (is.tframe(x)) UseMethod("latest.end.index.tframe")
   else 
     {tf <- list(tframe(x))
      for (i in list(...)) tf <- append(tf, list(tframe(i)))
      r <- do.call("latest.end.index.tframe", tf)
     }
   r
  }




###############################################

#  tframe  methods   <<<<<<<<<<<<

################################################
is.tframe <-function(tf) inherits(tf, "tframe")

is.tframed <-function(x) inherits(attr(x, "tframe"), "tframe")


tframe <-function(x)UseMethod("tframe")

tframe.default <-function(x)
{#extract the tframe
 if (is.tframed(x)) tf <- attr(x, "tframe")
 else 
   {if (is.ts(x)) tf <- tsp(x)
    else
     {if (is.matrix(x)) tf <-c(1, dim(x)[1], 1)
      else tf <- c(1, length(x), 1)
     }
    class(tf) <- c("tsptframe", "tframe")
   }
 tf
}

"tframe<-" <-function(x, tf)UseMethod("tframe<-")

"tframe<-.default" <-function(x,tf)
{# check if tf is consistent with x and then assign the tframe attr
 #  tf should have a main class of "tframe"
 if(is.null(tf)) 
   {attr(x, "tframe") <- NULL
    return(x)
   }
 if (!is.tframe(tf))
   {if( is.null(tf$start) & is.null(tf$end) )
       stop("tf must be of class tframe or a list of arguments for ts().")
    attr(x, "tframe") <- NULL  # in case this is reassignment of a tframed x
    tf <- tframe(do.call("ts", append(list(rep(NA,periods(x))),tf)))
   }
 if (!is.consistent.tframe(tf,x))
    stop("time frame in tframe assignment is not consistent with data.")

 attr(x, "tframe") <- tf 

 # clean out other possibly contradictory time info:
 tsp(x) <-NULL
 if (inherits(x,"rts") | inherits(x,"cts") |
     inherits(x,"its") | inherits(x,"ts")) class(x) <- NULL
 attr(x, "tspar") <- NULL
 if (!is.null(dimnames(x)[[2]])) 
   {nm <- vector("list", length(dimnames(x)))
    nm[[2]] <- dimnames(x)[[2]]
    dimnames(x) <- nm
   }
 x
}


tframed <-function(x, tf, names=NULL)
 {# return x as a tframed object with tframe tf
  tframe(x) <- tf
  if(!is.null(names)) dimnames(x) <- list(NULL,names)
  x
 }

to.tframed <-function(x) UseMethod("to.tframed")

to.tframed.default <-function(x)
 {# attempt to extract time info and return x as a tframed object
  if (!is.tframed(x))
    {if(is.ts(x)) tf <- list(start=start(x), frequency=frequency(x))
     tframe(x) <- tf
    }
  x
 }

print.tframe <-function(tf, digits=NULL, quote=T, prefix="", ...) 
   UseMethod("print.tframe")

print.tframe.default <-function(tf, digits=NULL, quote=T, prefix="", ...) 
   invisible(print(unclass(tf), quote=quote, prefix=prefix, ...))
   # digits=digits, seems to cause problems ?



start.tframe <- function(tf)UseMethod("start.tframe")
end.tframe   <- function(tf)UseMethod("end.tframe")

# periods should give the number of data points in the time direction.
periods.tframe <- function(tf)UseMethod("periods.tframe")

# frequency is less essential and may not always make sense.
frequency.tframe <-function(tf)UseMethod("frequency.tframe")

time.tframe <- function(tf)UseMethod("time.tframe")

truncate.tframe <-function(tf, start=NULL, end=NULL)
    {# tf truncated to correspond to a the tf of data[start:end] where
     #   NULL means no truncation.
     UseMethod("truncate.tframe")
    }

expand.tframe <-function(tf, add.start=0, add.end=0)
     UseMethod("expand.tframe")

is.consistent.tframe <-function(tf, x) UseMethod("is.consistent.tframe")

is.consistent.tframe.default <-function(tf, x) {periods(tf) == periods(x)}

test.equal.tframe <-function(tf1, tf2) UseMethod("test.equal.tframe")

test.equal.tframe.default <-function(tf1, tf2) { all(tf1==tf2)}

# Following could be used to do date comparisons like start() < end()

earliest.start.index.tframe <-function(x, ...)
    UseMethod("earliest.start.index.tframe")

earliest.start.tframe <-function(x, ...)
    append(list(x),list(...))[[earliest.start.index.tframe(x, ...)]]

earliest.end.index.tframe <-function(x, ...)
    UseMethod("earliest.end.index.tframe")

earliest.end.tframe <-function(x, ...)
    append(list(x),list(...))[[earliest.end.index.tframe(x, ...)]]

latest.start.index.tframe <-function(x, ...)
    UseMethod("latest.start.index.tframe")

latest.start.tframe <-function(x, ...)
    append(list(x),list(...))[[latest.start.index.tframe(x, ...)]]

latest.end.index.tframe <-function(x, ...)
    UseMethod("latest.end.index.tframe")

latest.end.tframe <-function(x, ...)
    append(list(x),list(...))[[latest.end.index.tframe(x, ...)]]


###############################################

#  tsp specific methods   <<<<<<<<<<<<

################################################

start.tframe.tsptframe <-function(tf) {c(floor(tf[1]), round(1 +(tf[1]%%1)*tf[3]))}

end.tframe.tsptframe <-function(tf) {c(floor(tf[2]), round(1 + (tf[2]%%1)*tf[3]))}

periods.tframe.tsptframe <-function(tf)  {1+round((tf[2]-tf[1])*tf[3])}

frequency.tframe.tsptframe <-function(tf) {tf[3]}

time.tframe.tsptframe <-function(tf) {tf[1] + (seq(periods(tf))-1)/tf[3]}

truncate.tframe.tsptframe <-function(tf, start=NULL, end=NULL) 
    {if (!is.null(end))   tf[2] <- tf[1] + (end-1)/tf[3]
     if (!is.null(start)) tf[1] <- tf[1] + (start-1)/tf[3]
     tf
    }

expand.tframe.tsptframe <-function(tf, add.start=0, add.end=0) 
    {tf[2] <- tf[2] + add.end/tf[3]
     tf[1] <- tf[1] - add.start/tf[3]
     tf
    }


earliest.start.index.tframe.tsptframe <-function(x, ...) 
    {r <- 1
     fr <- frequency(x)
     args <- list(x, ...)
     for (i in seq(length(args)))
         {tf <- args[[i]]
          if (tf[3] != fr) stop("frequencies must be that same.")
          if (tf[1] < args[[r]][1]) r <- i
         }           
     r
    }

earliest.end.index.tframe.tsptframe <-function(x, ...) 
    {r <- 1
     fr <- frequency(x)
     args <- list(x, ...)
     for (i in seq(length(args)))
         {tf <- args[[i]]
          if (tf[3] != fr) stop("frequencies must be that same.")
          if (tf[2] < args[[r]][2]) r <- i
         }           
     r
    }

latest.start.index.tframe.tsptframe <-function(x, ...) 
    {r <- 1
     fr <- frequency(x)
     args <- list(x, ...)
     for (i in seq(length(args)))
         {tf <- args[[i]]
          if (tf[3] != fr) stop("frequencies must be that same.")
          if (tf[1] > args[[r]][1]) r <- i
         }           
     r
    }

latest.end.index.tframe.tsptframe <-function(x, ...) 
    {r <- 1
     fr <- frequency(x)
     args <- list(x, ...)
     for (i in seq(length(args)))
         {tf <- args[[i]]
          if (tf[3] != fr) stop("frequencies must be that same.")
          if (tf[2] > args[[r]][2]) r <- i
         }           
     r
    }

print.tframed.tsptframe <- function(tf,x,...)
  {tframe(x) <- NULL
   x <- ts(x, start=start(tf), frequency=frequency(tf))
   tsp(x) <- NULL
   print(x)
  }

plot.tframed.tsptframe <- function(tf,y,...)
  {tframe(y) <- NULL
   matplot(x=time(tf), y=y, type="l", ...)
  }
#   tsp(y) <- tf
#   plot(y)
#   tsplot.default(y,  ...)
#   tsplot(y,  ...)  


###############################################

#  rts, cts, its specific methods   untested   <<<<<<<<<<<<

################################################
start.tframe.rtstframe<-start.tframe.ctstframe<-
   start.tframe.itstframe<-function(tf)
     UseMethod("start.tframe.tspar")

start.tframe.tspar <-function(tf)
   {x <- NULL
    attr(x,"tspar") <- tf
    class(x) <- class(tf)[1]
    start(x)
   }

end.tframe.rtstframe<-end.tframe.ctstframe<-end.tframe.itstframe<-function(tf)
     UseMethod("end.tframe.tspar")

end.tframe.tspar <-function(tf)
   {x <- NULL
    attr(x,"tspar") <- tf
    class(x) <- class(tf)[1]
    end(x)
   }

frequency.tframe.rtstframe<-frequency.tframe.ctstframe<-
    frequency.tframe.itstframe<-function(tf)
     UseMethod("frequency.tframe.tspar")

frequency.tframe.tspar <-function(tf)
   {x <- NULL
    attr(x,"tspar") <- tf
    class(x) <- class(tf)[1]
    frequency(x)
   }


periods.tframe.rtstframe<-periods.tframe.ctstframe<-
   periods.tframe.itstframe<-function(tf)
     UseMethod("periods.tframe.tspar")

periods.tframe.tspar <-function(tf)  {stop("not working")}

truncate.tframe.rtstframe<-truncate.tframe.ctstframe<-
   truncate.tframe.itstframe<-function(tf)
     UseMethod("truncate.tframe.tspar")

truncate.tframe.tspar <-function(tf, start=NULL, end=NULL) 
    {x <- NULL
    attr(x,"tspar") <- tf
    class(x) <- class(tf)[1]
    ntf <- attr(window(x, start=start, end=end), "tspar")
    class(ntf) <- class(tf)
    ntf
    }

is.consistent.tframe.tspar <-function(tf, x)
  {if (is.null(x))   return(T)  # this is debatable
   if (is.matrix(x)) return( periods.tframe.tspar(tf) == dim(x)[1])
   else              return( periods.tframe.tspar(tf) == length(x))
   NA
  }

window.tframed.rtstframe <- function(tf, x, ...)
 {tspar(x) <- tf
  class(x) <- "rts" 
  tframe(x) <- NULL
  x <- window(x,...)
  tframe(x) <- tframe(x) # strange but the default action fixes the class
  x
 }

window.tframed.ctstframe <- function(tf, x, ...)
 {tspar(x) <- tf
  class(x) <- "cts" 
  tframe(x) <- NULL
  x <- window(x,...)
  tframe(x) <- tframe(x) # strange but the default action fixes the class
  x
 }

window.tframed.itstframe <- function(tf, x, ...)
 {tspar(x) <- tf
  class(x) <- "its" 
  tframe(x) <- NULL
  x <- window(x,...)
  tframe(x) <- tframe(x) # strange but the default action fixes the class
  x
 }



###############################################

#  stamped specific methods   <<<<<<<<<<<<
#  stamped class TS have a date/time stamp associated with each time point
################################################
is.consistent.tframe.stamped <-function(tf, x)
  {periods(x) == periods(tf)}

test.equal.tframe.stamped <-function(tf1, tf2)
  {all(tf1$stamp == tf2$stamp)}

periods.tframe.stamped <- function(x)length(tframe(x))


###############################################

#  to be continued ... specific methods   <<<<<<<<<<<<

################################################

trim.na <- function(obj, ...) UseMethod("trim.na") 

trim.na.default <-function(x, Start=T, End=T)
{# trim NAs from the ends of a ts matrix.
 # (Observations for all series are dropped in a given period if any 
 #  one contains an NA in that period.)
 # if Start=F then beginning NAs are not trimmed.
 # If End=F   then ending NAs are not trimmed.
 sample <- ! apply(is.na(x),1, any)
 if (!any(sample)) warning("data is empty after triming NAs.")
 if (Start) s <-min(time(x)[sample])
 else       s <-start(x)
 if (End)   e <-max(time(x)[sample])
 else       e <-end(x)
 window(x,start=s, end=e, warn=F)
}


###############################################

#             tests   <<<<<<<<<<<<

################################################


tframe.function.tests <- function( verbose=T, synopsis=T)
{# A short set of tests of the tframe class methods. 

  all.ok <-  T
  if (synopsis & !verbose) cat("All tframe tests ...")
  if (verbose) cat("tframe test 1 ... ")
  tspvector <- ts(1:100, start=c(1981,3), frequency=4)
  data <- matrix(rnorm(300),100,3)
  tframe(data) <- tframe(tspvector)   
  ok <- is.tframed(data)
  all.ok <- ok
  if (verbose) 
    {if (ok) cat("ok\n")
     else    cat("failed!\n")
    }


  if (verbose) cat("tframe test 2 ... ")
  ok <- test.equal(tframe(data), tframe(data))
  all.ok <- all.ok & ok 
  if (verbose) 
    {if (ok) cat("ok\n")
     else    cat("failed!\n")
    }

  if (verbose) cat("tframe test 3 ... ")
  ok <- all(c(1981,3) == start(tspvector))
  ok <- ok & all(c(1981,3) == start(data))
  all.ok <- all.ok & ok 
  if (verbose) 
    {if (ok) cat("ok\n")
     else    cat("failed!\n")
    }

  if (verbose) cat("tframe test 4 ... ")
  ok <- all(end(data) == end(tspvector))
  all.ok <- all.ok & ok 
  if (verbose) 
    {if (ok) cat("ok\n")
     else    cat("failed!\n")
    }

  if (verbose) cat("tframe test 5 ... ")
  ok <- periods(data) == periods(tspvector)
  all.ok <- all.ok & ok 
  if (verbose) 
    {if (ok) cat("ok\n")
     else    cat("failed!\n")
    }

  if (verbose) cat("tframe test 6 ... ")
  ok <- frequency(data) == frequency(tspvector)
  all.ok <- all.ok & ok 
  if (verbose) 
    {if (ok) cat("ok\n")
     else    cat("failed!\n")
    }

  if (verbose) cat("tframe test 7 ... ")
  z <- data
  tframe(z) <- list( start=c(1961,2), frequency=12)
  ok <- is.tframed(z)
  all.ok <- all.ok & ok 
  if (verbose) 
    {if (ok) cat("ok\n")
     else    cat("failed!\n")
    }

  if (verbose) cat("tframe test 8 ... ")
  z <- data[10:90,]
  tframe(z) <- truncate.tframe(tframe(data), start=10, end=90)
  ok <- is.tframed(z)
  all.ok <- all.ok & ok 
  if (verbose) 
    {if (ok) cat("ok\n")
     else    cat("failed!\n")
    }

  if (verbose) cat("tframe test 9 ... ")
  z <- truncate(data, start=10, end=90)
  ok <- is.tframed(z)
  all.ok <- all.ok & ok 
  if (verbose) 
    {if (ok) cat("ok\n")
     else    cat("failed!\n")
    }

  if (verbose) cat("tframe test 10... ")
  data <- ts(matrix(rnorm(300),100,3), start=c(1961,1), frequency=12)
  z <- window(data, start=c(1963,2))
  tframe(z) <- tframe(z)  #the default action fixes z to be tframed
  zz <-data
  tframe(zz) <- tframe(zz)
  zz  <- window(zz, start=c(1963,2))
# Rbug needs zzz as follows
  zzz <- window(data, start=c(1963,2))
  zzz <- tframed(zzz, tframe(zzz))
  ok <- is.tframed(z) & is.tframed(zz) & 
      all(z==zz) & all(z==zzz)
#Rbug all(z==zz) & all(z==window(data,start=c(1963,2)))) ==does not work with ts
  all.ok <- all.ok & ok 
  if (verbose) 
    {if (ok) cat("ok\n")
     else    cat("failed!\n")
    }

  if (verbose) cat("tframe test 11... ")
  ok <- all( time(data) == time( tframed(data, tframe(data))))
  all.ok <- all.ok & ok 
  if (verbose) 
    {if (ok) cat("ok\n")
     else    cat("failed!\n")
    }

  if (verbose) cat("tframe test 12... ")
  z <- tsmatrix(1:10, 11:20)
  ok <- all( z== matrix(1:20, 10,2)) & all(start(z) ==1)
  all.ok <- all.ok & ok 
  if (verbose) 
    {if (ok) cat("ok\n")
     else    cat("failed!\n")
    }

  if (verbose) cat("tframe test 13... ")
  data <- tframed(matrix(rnorm(300),100,3),list( start=c(1961,1), frequency=12))
  z <- window(data, start=c(1963,2), end=c(1969,1))
  ok <-      all(start(data)== earliest.start(data, z))
  ok <- ok & all(    end(z) == earliest.end  (data, z))
  ok <- ok & all(start(z)   == latest.start  (data, z))
  ok <- ok & all( end(data) == latest.end   (data, z))
  all.ok <- all.ok & ok 
  if (verbose) 
    {if (ok) cat("ok\n")
     else    cat("failed!\n")
    }

  if (verbose) cat("tframe test 14... ")
  data <- tframed(matrix(rnorm(300),100,3),list( start=c(1961,1), frequency=12))
  z <- window(data, start=c(1963,2), end=c(1969,1))
  ok <- test.equal(data, splice(z, data))
  ok <- ok & test.equal(tframe(data), tframe(splice(z, data)))
  all.ok <- all.ok & ok 
  if (verbose) 
    {if (ok) cat("ok\n")
     else    cat("failed!\n")
    }

  if(!exists.graphics.device()) open.graphics.device()

# dev.ask(T)
# plot(data)
 tsplot(data)
# tsplot(matrix(rnorm(300),100,3))

  if (synopsis) 
    {if (verbose) cat("All tframe tests completed")
     if (all.ok) cat(" ok\n")
     else    cat(", some failed!\n")
    }
  invisible(all.ok)
}

#   Copyright 1993, 1994, 1995, 1996  Bank of Canada.
#   Copyright 1997 (June), Paul Gilbert.
#   Copyright 1997 (Aug.), Bank of Canada.
#   Copyright 1998, Bank of Canada.

#   The user of this software has the right to use, reproduce and distribute it.
#   Bank of Canada makes no warranties with respect to the software or its 
#   fitness for any particular purpose. The software is distributed by the Bank
#   of Canada and by Paul Gilbert solely on an "as is" basis. By using the  
#   software, user agrees to accept the entire risk of using this software.

################################################################################




#start.default <- function (x) start(ts(x))
#end.default   <- function (x)   end(ts(x))
#frequency.default <- function (x)
#  {if (!is.null(tsp(x))) return(tsp(x)[3])
#   else return(1)
#  }

# Some notes and hopefully temporary R changes and additions

# is .First.lib supported?
# getenv() should return everything, not complain missing item.

dev.ask <- function(ask=T){par(ask=ask)}
 

Inf <- NA   # something better would be nice


summary.default <- function (object, ..., digits = max(options()$digits - 3, 3)) 
{
	if (is.factor(object)) 
		return(summary.factor(object, ...))
	else if (is.matrix(object)) 
		return(summary.matrix(object, ...))
	value <- if (is.numeric(object)) {
		nas <- is.na(object)
		object <- object[!nas]
		qq <- quantile(object)
		qq <- signif(c(qq[1:3], mean(object), qq[4:5]), digits)
		names(qq) <- c("Min.", "1st Qu.", "Median", "Mean", "3rd Qu.", "Max.")
		if (any(nas)) c(qq, NAs = sum(nas))
		else qq
	}
	else if (is.recursive(object) && !is.language(object) && (n <- length(object
	))) {sumry <- array("", c(n, 3), list(names(object), c("Length", "Class", 
			"Mode")))
		ll <- numeric(n)
		for (i in 1:n) {
			ii <- object[[i]]
			ll[i] <- length(ii)
			sumry[i, 2] <- if (is.object(ii)) 
				paste(class(ii), collapse=" ") #class(ii)
			else "-none-"
			sumry[i, 3] <- mode(ii)
		}
		sumry[, 1] <- format(as.integer(ll))
		class(sumry) <- "table"
		sumry
	}
	else c(Length = length(object), Class = class(object), Mode = mode(object
	))
	class(value) <- "table"
	value
}




#########################

#  misc R fixes and additions

#########################


est.VARX.ar <- function(data, subtract.means=F,  re.add.means=T, standardize=F,
      unstandardize=T, aic=T, max.lag=NULL, method="yule-walker", warn=T) 
    {if (warn)warning("using est.VARX.ls instead of est.VARX.ar for R testing.")
    # Rbug no ar function  
     est.VARX.ls(data, subtract.means=subtract.means,re.add.means=re.add.means,
        standardize=standardize,  unstandardize=unstandardize, max.lag=max.lag,
        trend=F, lag.weight=1.0, warn=warn) 
    }

  
ar.test <-function(x, aic=T, order.max=2, method="yule-walker")
   {# this seems to work, in the sense of producing estimates which are
    # asymtotically as good as (or as bad as) Splus ar, at least for 
    # stationary data. But estimates are not the same.
    # For non-stationary data Splus ar does better, but neither method is really valid.
    if(method=="burg") stop("burg method for ar not yet implemented.")
    warning(" ar function not complete and not checked & default order.max=2.")
    if (is.vector(x))x <- matrix(x, length(x),1)
    sampleT <- nrow(x)
    if (is.null(order.max)) order.max <- round(10*log10(sampleT/ncol(x)))
    AC <- array(NA, c(order.max+1, ncol(x), ncol(x)))
x <- unclass(x)
tsp(x) <-NULL
    x <- x - t(array(apply(x,2,sum)/nrow(x), rev(dim(x))))
    for (i in 0:order.max)
	  {Om<- (t(x[(i+1):sampleT,,drop=F]) %*% 
                   x[1:(sampleT-i),,drop=F])/(sampleT-i)
	#   Om<- cor(x[(i+1):sampleT,,drop=F],
        #            x[1:(sampleT-i),,drop=F]) # cor seems better than var
       #    if(i==0) Om0 <- solve(Om)
       #                     # nrow above for univariate case
       #    Om <- Om0 %*% Om  #Yule-Walker eqn. should solve without this
           AC[i+1,,] <-  Om
          }

   # now solve yule walker eqns.
   n <- ncol(x)
   a <- matrix(NA, n*(order.max), n*(order.max) )
   b <- matrix(NA, n*(order.max), n )
   # using AC[1,,] in place of I
   # there must be a better way (with outer?)
    for (i in 0:(order.max-1))
       for (j in 0:(order.max-1))
	  a[(1+i*n):(n+i*n),(1+j*n):(n+j*n)] <- AC[abs(i-j)+1,,] 
    for (i in 1:order.max)
	  b[(1+(i-1)*n):(i*n),] <- AC[i+1,,] 
   AR <-solve(a, b)
   if (n==1) AR <- matrix(AR, length(AR), 1)
   #AR <- solve(t(a),b) # the off-diag values may require this??
 #  ar <- aperm(array(AR,c(dim(AC)-c(1,0,0))), c(2,1,3)) 
    ar <- array(NA, c(order.max, ncol(x), ncol(x)))
    for (i in 1:order.max)
	ar[i,,] <- AR[(1+(i-1)*n):(i*n),]  
   order <- order.max # need aic here
   list(ar=ar, order=order, order.max=order.max, method=method)
   }


acf <-function (residual, plot = F, type = "correlation") 
       {if (plot) warning(" acf plot not yet supported.")
        if(0==charmatch(type,c("covariance","correlation","partial"),nomatch=0))
             stop("type not allowed in acf")
        if (is.vector(residual))residual <- matrix(residual, length(residual),1)
	sampleT <- nrow(residual)
        N <- round(10*(log10(sampleT)-log10(ncol(residual)))) 
        acf <- array(NA, c(N, ncol(residual), ncol(residual)))
	for (i in 0:(N-1))
	  {Om<- cov(residual[(i+1):sampleT,,drop=F], 
                    residual[1:(sampleT-i),,drop=F])
           if (type=="correlation")
                {if(i==0) Om0 <- diag(1/sqrt(diag(Om)),nrow=nrow(Om))
                            # nrow above for univariate case
                 Om <- Om0 %*% Om %*% Om0
                }
           acf[i+1,,] <-  Om 
          }
        if (type=="partial") 
          {warning("acf type partial not yet supported. 0 value being returned")
           acf <- array(0, dim(acf))
          }
	list(acf=acf, type=type )
       }



#  R fixes for tframe

print.tframe.default <-function (tf, digits = NULL, quote = T, prefix = "", ...)
invisible(print(unclass(tf), quote = quote))
#invisible(print(unclass(tf), quote = quote, prefix = prefix, ...))
# to avoid: Error in print.default(unclass(tf), quote = quote, prefix = prefix) : unused argument to function

# or ... could be added to print.default


"[.ts" <- function (x, i, j, drop = T) 
{
        y <- NextMethod("[")
        if (missing(i)) 
                ts(y, start = start(x), freq = frequency(x))
        else {
                n <- if (is.matrix(x)) 
                        nrow(x)
                else length(x)
                li <- length(ind <- (1:n)[i])
                if (li > 1) 
                        delta <- unique(ind[-1] - ind[-li])
                if (li <= 1 || length(delta) != 1) {
#                        warning("Not returning a time series object")
                }
                else {
                        xtsp <- tsp(x)
                        xtimes <- seq(from = xtsp[1], to = xtsp[2], 
                                by = 1/xtsp[3])
                        ytsp <- xtimes[range(ind)]
                        tsp(y) <- c(ytsp, (li - 1)/(ytsp[2] - 
                                ytsp[1]))
                }
                y
        }
}
