\name{diana}
\title{
Divisive Analysis
}
\usage{
diana(x, diss=F, metric="euclidean", stand=F)


}
\arguments{
\item{x}{
data matrix or dataframe, or dissimilarity matrix, depending on the
value of the \code{diss} argument.


In case of a matrix or dataframe, each row corresponds to an observation,
and each column corresponds to a variable. All variables must be numeric.
Missing values (NAs) are allowed.


In case of a dissimilarity matrix, \code{x} is typically the output of \code{daisy} or
\code{dist}. Also a vector with length n*(n-1)/2 is allowed (where n is the
number of objects), and will be interpreted in the same way as the output
of the above-mentioned functions. Missing values (NAs) are not allowed.


}
\item{diss}{
logical flag: if TRUE, then \code{x} will be considered as a dissimilarity
matrix. If FALSE, then \code{x} will be considered as a matrix of
observations by variables.


}
\item{metric}{
character string specifying the metric to be used for calculating
dissimilarities between objects.
The currently available options are "euclidean" and "manhattan".
Euclidean distances are root sum-of-squares of differences, and
manhattan distances are the sum of absolute differences.
If \code{x} is already a dissimilarity matrix, then this argument will
be ignored.


}
\item{stand}{
logical flag: if TRUE, then the measurements in \code{x} are standardized before
calculating the dissimilarities. Measurements are standardized for each
variable (column), by subtracting the variable's mean value and dividing by 
the variable's mean absolute deviation.
If \code{x} is already a dissimilarity matrix, then this argument
will be ignored.


}}
\value{
an object of class \code{"diana"} representing the clustering.
See diana.object for details.


}
\description{
\code{diana} is fully described in chapter 6 of Kaufman and Rousseeuw (1990).
It is probably unique in computing a divisive hierarchy, whereas most
other software for hierarchical clustering is agglomerative.
Moreover, \code{diana} provides (a) the divisive coefficient
(see \code{diana.object}) which measures the amount of clustering structure
found; and (b) the banner, a novel graphical display
(see \code{plot.diana}).


The \code{diana}-algorithm constructs a hierarchy of clusterings,
starting with one large
cluster containing all n objects. Clusters are divided until each cluster
contains only a single object.
At each stage, the cluster with the largest diameter is selected.
(The diameter of a cluster is the largest dissimilarity between any
two of its objects.)
To divide the selected cluster, the algorithm first looks for its most
disparate object (i.e., which has the largest average dissimilarity to the
other objects of the selected cluster). This object initiates the
"splinter group". In subsequent steps, the algorithm reassigns objects
that are closer to the "splinter group" than to the "old party". The result
is a division of the selected cluster into two new clusters.


}
\section{BACKGROUND}{
Cluster analysis divides a dataset into groups (clusters) of objects that
are similar to each other. Hierarchical methods like \code{agnes}, \code{diana}, and
\code{mona} construct a hierarchy of clusterings, with the number of clusters
ranging from one to the number of objects. Partitioning methods like \code{pam},
\code{clara}, and \code{fanny} require that the number of clusters be given by
the user.


}
\references{
Kaufman, L. and Rousseeuw, P.J. (1990). Finding Groups in Data: An
Introduction to Cluster Analysis. Wiley, New York.


}
\seealso{
\code{\link{diana.object}}, \code{\link{daisy}}, \code{\link{dist}}, \code{\link{plot.diana}}, \code{\link{pltree.diana}}, \code{\link{agnes}}.


}
\examples{
dia1 <- diana(votes.repub, metric="manhattan", stand=T)
print(dia1)
plot(dia1)


dia2 <- diana(daisy(votes.repub), diss=T, method="complete")
pltree(dia2)


diana(dist(votes.repub), diss=T)


}
\keyword{all}
\keyword{cluster}
% Converted by Sd2Rd version 0.2-a3.
